/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wurstclient.zoom.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import net.wurstclient.zoom.WiZoom;

@Mixin(class_757.class)
public abstract class GameRendererMixin implements AutoCloseable
{
	@Inject(at = @At(value = "RETURN", ordinal = 1),
		method = "getFov(Lnet/minecraft/client/render/Camera;FZ)F",
		cancellable = true)
	private void onGetFov(class_4184 camera, float tickDelta, boolean changingFov,
		CallbackInfoReturnable<Float> cir)
	{
		cir.setReturnValue(
			WiZoom.INSTANCE.changeFovBasedOnZoom(cir.getReturnValueF()));
	}
}
