/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.message;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.lukiiy.message.cmds.Msg;
import me.lukiiy.message.cmds.Reply;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Message
extends JavaPlugin {
    public static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final HashMap<UUID, UUID> replyData = new HashMap();

    public void onEnable() {
        this.setupConfig();
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            ((Commands)event.registrar()).register(new Msg().register(), "Sends a private message to a player", List.of("tell", "write", "w", "msg", "whisper"));
            ((Commands)event.registrar()).register(new Reply().register(), "Replies to a private message", List.of("r"));
        });
    }

    public void onDisable() {
    }

    public static Message getInstance() {
        return (Message)JavaPlugin.getPlugin(Message.class);
    }

    public void setupConfig() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    @NotNull
    public Component formattedConfigMessage(String path) {
        return MINI_MESSAGE.deserialize((Object)this.getConfig().getString("msgs." + path, "<red><i>Message not set.").replace("\u00a7", ""));
    }

    public void message(@NotNull CommandSender sender, @NotNull Player receiver, @NotNull String content) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.getConfig().getBoolean("visibilityCheck") && !player.canSee(receiver)) {
                sender.sendMessage(this.formattedConfigMessage("notfound"));
                return;
            }
            if (!this.getConfig().getBoolean("selfMsg") && player.equals((Object)receiver)) {
                sender.sendMessage(this.formattedConfigMessage("self"));
                return;
            }
            this.replyData.put(player.getUniqueId(), receiver.getUniqueId());
            this.replyData.put(receiver.getUniqueId(), player.getUniqueId());
        }
        Component toMsg = this.formattedConfigMessage("to").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%p").replacement(receiver.getName()).build());
        Component fromMsg = this.formattedConfigMessage("from").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%p").replacement(sender.getName()).build());
        TextComponent formatted = this.getConfig().getBoolean("formatting") ? LegacyComponentSerializer.legacyAmpersand().deserialize(content) : Component.text((String)content);
        sender.sendMessage(toMsg.append((Component)formatted));
        receiver.sendMessage(fromMsg.append((Component)formatted));
        String sfxId = this.getConfig().getString("sfx.id", "");
        if (!sfxId.isEmpty()) {
            receiver.playSound(Sound.sound((Key)Key.key((String)sfxId), (Sound.Source)Sound.Source.PLAYER, (float)((float)this.getConfig().getDouble("sfx.volume", 1.0)), (float)((float)this.getConfig().getDouble("sfx.pitch", 1.0))));
        }
    }

    @Nullable
    public UUID getLastReply(Player player) {
        return this.replyData.get(player.getUniqueId());
    }
}

