/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.message;

import java.util.HashMap;
import java.util.UUID;
import me.lukiiy.message.cmds.Msg;
import me.lukiiy.message.cmds.Reply;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Message
extends JavaPlugin {
    public static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final HashMap<UUID, UUID> replyData = new HashMap();
    public BukkitAudiences audience;

    public void onEnable() {
        this.setupConfig();
        this.audience = BukkitAudiences.create((Plugin)this);
        this.getCommand("msg").setExecutor((CommandExecutor)new Msg());
        this.getCommand("r").setExecutor((CommandExecutor)new Reply());
    }

    public void onDisable() {
        this.audience.close();
        this.audience = null;
    }

    public static Message getInstance() {
        return (Message)JavaPlugin.getPlugin(Message.class);
    }

    public BukkitAudiences getAudience() {
        return this.audience;
    }

    public void setupConfig() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    @NotNull
    public Component formattedConfigMessage(String path) {
        return MINI_MESSAGE.deserialize(this.getConfig().getString("msgs." + path, "<red><i>Message not set.").replace("\u00a7", ""));
    }

    public void message(@NotNull CommandSender sender, @NotNull Player receiver, @NotNull String content) {
        Audience senderAudience = this.audience.sender(sender);
        Audience receiverAudience = this.audience.player(receiver);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.getConfig().getBoolean("visibilityCheck") && !player.canSee(receiver)) {
                senderAudience.sendMessage(this.formattedConfigMessage("notfound"));
                return;
            }
            if (!this.getConfig().getBoolean("selfMsg") && player.equals((Object)receiver)) {
                senderAudience.sendMessage(this.formattedConfigMessage("self"));
                return;
            }
            this.replyData.put(player.getUniqueId(), receiver.getUniqueId());
            this.replyData.put(receiver.getUniqueId(), player.getUniqueId());
        }
        Component toMsg = this.formattedConfigMessage("to").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%p").replacement(receiver.getName()).build());
        Component fromMsg = this.formattedConfigMessage("from").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%p").replacement(sender.getName()).build());
        TextComponent formatted = this.getConfig().getBoolean("formatting") ? LegacyComponentSerializer.legacyAmpersand().deserialize(content) : Component.text(content);
        senderAudience.sendMessage(toMsg.append(formatted));
        receiverAudience.sendMessage(fromMsg.append(formatted));
        String sfxId = this.getConfig().getString("sfx.id", "");
        if (!sfxId.isEmpty()) {
            receiverAudience.playSound(Sound.sound(Key.key(sfxId), Sound.Source.PLAYER, (float)this.getConfig().getDouble("sfx.volume", 1.0), (float)this.getConfig().getDouble("sfx.pitch", 1.0)));
        }
    }

    @Nullable
    public UUID getLastReply(Player player) {
        return this.replyData.get(player.getUniqueId());
    }
}

