/*
 * Decompiled with CFR 0.152.
 */
package com.l33tfox.soniccycle.entity;

import com.google.common.collect.Lists;
import com.l33tfox.soniccycle.entity.ModEntityTypes;
import com.l33tfox.soniccycle.item.ModItemsRegistry;
import com.l33tfox.soniccycle.networking.payload.SonicCyclePositionC2SPayload;
import com.l33tfox.soniccycle.networking.payload.SonicCycleVelocityC2SPayload;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2553;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5712;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7260;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.minecraft.class_9817;
import org.jetbrains.annotations.Nullable;

public class SonicCycleEntity
extends class_1309 {
    protected static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(SonicCycleEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(SonicCycleEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(SonicCycleEntity.class, (class_2941)class_2943.field_13320);
    private float velocityDecay;
    private float ticksUnderwater;
    public float prevYawVelocity;
    public float yawVelocity;
    private int lerpTicks;
    private double x;
    private double y;
    private double z;
    private double sonicCycleYaw;
    private double sonicCyclePitch;
    private boolean pressingLeft;
    private boolean pressingRight;
    private boolean pressingForward;
    private boolean pressingBack;
    private double waterLevel;
    private float nearbySlipperiness;
    private Location location;
    private Location lastLocation;
    private double fallVelocity;
    @Nullable
    private class_9817.class_9818 leashData;
    public float wheelRotation = 0.0f;
    private Queue<class_243> prevPositionsWhenControlled = new LinkedList<class_243>();
    private boolean pressingJump;
    public boolean usingSpeedBoost;

    public SonicCycleEntity(class_1299<? extends SonicCycleEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public SonicCycleEntity(class_1937 world, double x, double y, double z) {
        this(ModEntityTypes.SONIC_CYCLE, world);
        this.method_5814(x, y, z);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 10.0);
    }

    public float method_49476() {
        return 1.5f;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean bl;
        if (this.method_37908().field_9236 || this.method_31481()) {
            return true;
        }
        if (this.method_5679(source)) {
            return false;
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.method_5785();
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
        this.method_32875((class_6880)class_5712.field_28736, source.method_5529());
        boolean bl2 = bl = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_31549().field_7477;
        if (bl || !(this.getDamageWobbleStrength() > 40.0f)) {
            if (bl) {
                this.method_31472();
            }
        } else {
            this.killAndDropSelf(source);
        }
        return true;
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876((class_6880)class_5712.field_37676);
    }

    public void killAndDropItem(class_1792 selfAsItem) {
        this.method_5768();
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_1799 itemStack = new class_1799((class_1935)selfAsItem);
            itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
            this.method_5775(itemStack);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DAMAGE_WOBBLE_TICKS, (Object)0);
        builder.method_56912(DAMAGE_WOBBLE_SIDE, (Object)1);
        builder.method_56912(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        super.method_5693(builder);
    }

    public void setDamageWobbleTicks(int damageWobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, (Object)damageWobbleTicks);
    }

    public void setDamageWobbleSide(int damageWobbleSide) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, (Object)damageWobbleSide);
    }

    public void setDamageWobbleStrength(float damageWobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(damageWobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    public double method_53830() {
        return this.lerpTicks > 0 ? this.x : this.method_23317();
    }

    public double method_53827() {
        return this.lerpTicks > 0 ? this.y : this.method_23318();
    }

    public double method_53828() {
        return this.lerpTicks > 0 ? this.z : this.method_23321();
    }

    public float method_53829() {
        return this.lerpTicks > 0 ? (float)this.sonicCyclePitch : this.method_36455();
    }

    public float method_53831() {
        return this.lerpTicks > 0 ? (float)this.sonicCycleYaw : this.method_36454();
    }

    public class_2350 method_5755() {
        return this.method_5735().method_10170();
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    protected void killAndDropSelf(class_1282 source) {
        this.killAndDropItem(this.asItem());
    }

    public class_1792 asItem() {
        return ModItemsRegistry.SONIC_CYCLE;
    }

    public boolean method_6049(class_1293 effect) {
        return false;
    }

    public void method_5749(class_2487 nbt) {
    }

    protected double method_7490() {
        if (this.method_5799()) {
            return 0.005;
        }
        return 0.1;
    }

    public void method_5697(class_1297 entity) {
        if (entity instanceof SonicCycleEntity) {
            if (entity.method_5829().field_1322 < this.method_5829().field_1325) {
                super.method_5697(entity);
            }
        } else if (entity.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entity);
        }
    }

    public Iterable<class_1799> method_5661() {
        return class_2371.method_37434((int)0);
    }

    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    public class_1306 method_6068() {
        return null;
    }

    public void method_5652(class_2487 nbt) {
    }

    public void method_5879(float yaw) {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    private void updatePositionAndRotation() {
        if (this.method_5787()) {
            this.lerpTicks = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.lerpTicks > 0) {
            this.method_52532(this.lerpTicks, this.x, this.y, this.z, this.sonicCycleYaw, this.sonicCyclePitch);
            --this.lerpTicks;
        }
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.sonicCycleYaw = yaw;
        this.sonicCyclePitch = pitch;
        this.lerpTicks = 10;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1269 actionResult = super.method_5688(player, hand);
        if (actionResult != class_1269.field_5811) {
            return actionResult;
        }
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (this.ticksUnderwater < 60.0f) {
            if (!this.method_37908().field_9236) {
                this.prevPositionsWhenControlled = new LinkedList<class_243>();
                return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        super.method_5865(passenger, positionUpdater);
        if (!passenger.method_5864().method_20210(class_3483.field_47578)) {
            passenger.method_36456(passenger.method_36454() + this.yawVelocity);
            passenger.method_5847(passenger.method_5791() + this.yawVelocity);
            this.clampPassengerYaw(passenger);
            if (passenger instanceof class_1429 && this.method_5685().size() == this.getMaxPassengers()) {
                int i = passenger.method_5628() % 2 == 0 ? 90 : 270;
                passenger.method_5636(((class_1429)passenger).field_6283 + (float)i);
                passenger.method_5847(passenger.method_5791() + (float)i);
            }
        }
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 vec3d = SonicCycleEntity.method_24826((double)(this.method_17681() * class_3532.field_15724), (double)passenger.method_17681(), (float)passenger.method_36454());
        double d = this.method_23317() + vec3d.field_1352;
        double e = this.method_23321() + vec3d.field_1350;
        class_2338 blockPos = class_2338.method_49637((double)d, (double)this.method_5829().field_1325, (double)e);
        class_2338 blockPos2 = blockPos.method_10074();
        if (!this.method_37908().method_22351(blockPos2)) {
            double g;
            ArrayList list = Lists.newArrayList();
            double f = this.method_37908().method_30347(blockPos);
            if (class_5275.method_27932((double)f)) {
                list.add(new class_243(d, (double)blockPos.method_10264() + f, e));
            }
            if (class_5275.method_27932((double)(g = this.method_37908().method_30347(blockPos2)))) {
                list.add(new class_243(d, (double)blockPos2.method_10264() + g, e));
            }
            for (class_4050 entityPose : passenger.method_24831()) {
                for (class_243 vec3d2 : list) {
                    if (!class_5275.method_33353((class_1941)this.method_37908(), (class_243)vec3d2, (class_1309)passenger, (class_4050)entityPose)) continue;
                    passenger.method_18380(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.method_24829(passenger);
    }

    protected void clampPassengerYaw(class_1297 passenger) {
        passenger.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(passenger.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        passenger.field_5982 += g - f;
        passenger.method_36456(passenger.method_36454() + g - f);
        passenger.method_5847(passenger.method_36454());
    }

    public void method_5644(class_1297 passenger) {
        this.clampPassengerYaw(passenger);
    }

    @Nullable
    private Location getUnderWaterLocation() {
        class_238 box = this.method_5829();
        double d = box.field_1325 + 0.001;
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)d);
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (!fluidState.method_15767(class_3486.field_15517) || !(d < (double)((float)mutable.method_10264() + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable)))) continue;
                    if (!fluidState.method_15771()) {
                        return Location.UNDER_FLOWING_WATER;
                    }
                    bl = true;
                }
            }
        }
        return bl ? Location.UNDER_WATER : null;
    }

    public void setInputs(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack, boolean jumping) {
        this.pressingLeft = pressingLeft;
        this.pressingRight = pressingRight;
        this.pressingForward = pressingForward;
        this.pressingBack = pressingBack;
        this.pressingJump = jumping;
    }

    private boolean checkSonicCycleInWater() {
        class_238 box = this.method_5829();
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1322);
        int l = class_3532.method_15384((double)(box.field_1322 + 0.001));
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        this.waterLevel = -1.7976931348623157E308;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (!fluidState.method_15767(class_3486.field_15517)) continue;
                    float f = (float)p + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    bl |= box.field_1322 < (double)f;
                }
            }
        }
        return bl;
    }

    public float getNearbySlipperiness() {
        class_238 box = this.method_5829();
        class_238 box2 = new class_238(box.field_1323, box.field_1322 - 0.001, box.field_1321, box.field_1320, box.field_1322, box.field_1324);
        int i = class_3532.method_15357((double)box2.field_1323) - 1;
        int j = class_3532.method_15384((double)box2.field_1320) + 1;
        int k = class_3532.method_15357((double)box2.field_1322) - 1;
        int l = class_3532.method_15384((double)box2.field_1325) + 1;
        int m = class_3532.method_15357((double)box2.field_1321) - 1;
        int n = class_3532.method_15384((double)box2.field_1324) + 1;
        class_265 voxelShape = class_259.method_1078((class_238)box2);
        float f = 0.0f;
        int o = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int p = i; p < j; ++p) {
            for (int q = m; q < n; ++q) {
                int r = (p != i && p != j - 1 ? 0 : 1) + (q != m && q != n - 1 ? 0 : 1);
                if (r == 2) continue;
                for (int s = k; s < l; ++s) {
                    if (r > 0 && (s == k || s == l - 1)) continue;
                    mutable.method_10103(p, s, q);
                    class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
                    if (blockState.method_26204() instanceof class_2553 || !class_259.method_1074((class_265)blockState.method_26220((class_1922)this.method_37908(), (class_2338)mutable).method_1096((double)p, (double)s, (double)q), (class_265)voxelShape, (class_247)class_247.field_16896)) continue;
                    f += blockState.method_26204().method_9499();
                    ++o;
                }
            }
        }
        return f / (float)o;
    }

    private Location checkLocation() {
        Location location = this.getUnderWaterLocation();
        if (location != null) {
            this.waterLevel = this.method_5829().field_1325;
            return location;
        }
        if (this.checkSonicCycleInWater()) {
            return Location.IN_WATER;
        }
        float f = this.getNearbySlipperiness();
        if (f > 0.0f) {
            this.nearbySlipperiness = f;
            return Location.ON_LAND;
        }
        return Location.IN_AIR;
    }

    private void updateVelocityFromInput() {
        if (this.method_5782()) {
            float f = 0.0f;
            if (this.pressingLeft) {
                this.yawVelocity -= 1.0f;
            }
            if (this.pressingRight) {
                this.yawVelocity += 1.0f;
            }
            if (this.pressingRight != this.pressingLeft && !this.pressingForward && !this.pressingBack) {
                f += 0.005f;
            }
            if (this.pressingForward) {
                f += 0.08f;
            }
            if (this.pressingBack) {
                f -= 0.02f;
            }
            if (this.pressingForward && this.pressingJump) {
                this.usingSpeedBoost = true;
                f += 0.015f;
                if (this.pressingLeft) {
                    this.yawVelocity = (float)((double)this.yawVelocity + 0.6);
                }
                if (this.pressingRight) {
                    this.yawVelocity = (float)((double)this.yawVelocity - 0.6);
                }
            } else {
                this.usingSpeedBoost = false;
            }
            this.method_36456(this.method_36454() + this.yawVelocity);
            this.method_18799(this.method_18798().method_1031((double)(class_3532.method_15374((float)(-this.method_36454() * ((float)Math.PI / 180))) * f), 0.0, (double)(class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * f)));
        }
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 livingEntity;
        class_1297 class_12972 = this.method_31483();
        return class_12972 instanceof class_1309 ? (livingEntity = (class_1309)class_12972) : super.method_5642();
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        this.fallVelocity = this.method_18798().field_1351;
        if (!this.method_5765() && !this.method_37908().method_8316(this.method_24515().method_10074()).method_15767(class_3486.field_15517) && heightDifference < 0.0) {
            this.field_6017 -= (float)heightDifference;
        }
    }

    private void updateVelocity() {
        double d = -this.method_56989();
        double e = 0.0;
        this.velocityDecay = 0.05f;
        if (this.lastLocation == Location.IN_AIR && this.location != Location.IN_AIR && this.location == Location.IN_WATER) {
            this.location = Location.IN_WATER;
        } else {
            if (this.location == Location.IN_WATER) {
                this.velocityDecay = 0.45f;
            } else if (this.location == Location.UNDER_FLOWING_WATER) {
                d = -7.0E-4;
                this.velocityDecay = 0.45f;
            } else if (this.location == Location.UNDER_WATER) {
                e = 0.01f;
                this.velocityDecay = 0.45f;
            } else if (this.location == Location.IN_AIR) {
                this.velocityDecay = 0.9f;
            } else if (this.location == Location.ON_LAND) {
                this.velocityDecay = Math.max(0.9f, this.nearbySlipperiness);
                if (this.method_5642() instanceof class_1657) {
                    this.nearbySlipperiness /= 2.0f;
                }
            }
            class_243 vec3d = this.method_18798();
            this.method_18800(vec3d.field_1352 * (double)this.velocityDecay, vec3d.field_1351 + d, vec3d.field_1350 * (double)this.velocityDecay);
            this.yawVelocity *= this.velocityDecay;
        }
    }

    protected float getPassengerHorizontalOffset() {
        return 0.35f;
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 dimensions, float scaleFactor) {
        float f = this.getPassengerHorizontalOffset();
        return new class_243(0.0, 0.2, (double)f).method_1024(-this.method_36454() * ((float)Math.PI / 180));
    }

    protected int getMaxPassengers() {
        return 1;
    }

    private void updatePastPositions() {
        if (this.method_5642() != null) {
            this.prevPositionsWhenControlled.add(this.method_19538());
            while (this.prevPositionsWhenControlled.size() > 40) {
                this.prevPositionsWhenControlled.poll();
            }
        } else if (!this.prevPositionsWhenControlled.isEmpty()) {
            this.prevPositionsWhenControlled.poll();
        }
    }

    private void createSonicBoomTrail() {
        if (this.method_37908().field_9236 && (this.method_42148() || !this.prevPositionsWhenControlled.isEmpty())) {
            class_638 world = (class_638)this.method_37908();
            double trackedX = this.method_43389().method_60933().field_1352;
            double trackedY = this.method_43389().method_60933().field_1351;
            double trackedZ = this.method_43389().method_60933().field_1350;
            for (class_243 vec : this.prevPositionsWhenControlled) {
                if (!((double)class_3532.method_15379((float)((float)(trackedX - vec.field_1352))) > 0.75) && !((double)class_3532.method_15379((float)((float)(trackedY - vec.field_1351))) > 0.75) && !((double)class_3532.method_15379((float)((float)(trackedZ - vec.field_1350))) > 0.75)) continue;
                world.method_8406((class_2394)class_2398.field_38908, vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0);
            }
        }
    }

    private void checkSonicBoomCollisions() {
        if (!(this.method_37908().field_9236 || !this.method_42148() && this.prevPositionsWhenControlled.isEmpty())) {
            class_3218 world = (class_3218)this.method_37908();
            ArrayList entitiesHit = new ArrayList();
            for (class_243 vec : this.prevPositionsWhenControlled) {
                entitiesHit.addAll(world.method_8335((class_1297)this.method_5642(), new class_238(vec.field_1352 + 0.5, vec.field_1351 + 0.5, vec.field_1350 + 0.5, vec.field_1352 - 0.5, vec.field_1351 - 0.5, vec.field_1350 - 0.5)));
            }
            for (class_1297 ent : entitiesHit) {
                if (ent instanceof SonicCycleEntity || !(ent instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)ent;
                if (ent instanceof class_7260 || !livingEntity.method_5643(world.method_48963().method_48821((class_1297)this.method_5642()), 8.0f)) continue;
                double d = 0.5 * (1.0 - livingEntity.method_45325(class_5134.field_23718));
                double e = 2.5 * (1.0 - livingEntity.method_45325(class_5134.field_23718));
                class_243 vec3d = livingEntity.method_18798().method_1029();
                livingEntity.method_5762(-vec3d.method_10216() * e, d, -vec3d.method_10215() * e);
                world.method_47967(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), class_3417.field_38830, this.method_5634(), 1.0f, 1.0f, world.method_8409().method_43055());
            }
        }
    }

    private void createSmokeParticlesWhenSpeedBoost() {
        if (this.method_37908().field_9236 && this.usingSpeedBoost) {
            class_638 world = (class_638)this.method_37908();
            double trackedX = this.method_43389().method_60933().field_1352;
            double trackedY = this.method_43389().method_60933().field_1351;
            double trackedZ = this.method_43389().method_60933().field_1350;
            world.method_8406((class_2394)class_2398.field_46911, trackedX, trackedY + 0.5, trackedZ, 0.0, 0.0, 0.0);
        }
    }

    public void method_6007() {
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
    }

    public void method_5773() {
        this.lastLocation = this.location;
        this.location = this.checkLocation();
        this.prevYawVelocity = this.yawVelocity;
        this.ticksUnderwater = this.location != Location.UNDER_WATER && this.location != Location.UNDER_FLOWING_WATER ? 0.0f : (this.ticksUnderwater += 1.0f);
        if (this.field_5976) {
            this.method_24830(true);
        }
        if (!this.method_37908().field_9236 && this.ticksUnderwater >= 30.0f) {
            this.method_5772();
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.method_5773();
        this.updatePositionAndRotation();
        if (this.method_5787()) {
            this.updateVelocity();
            if (this.method_37908().field_9236) {
                this.updateVelocityFromInput();
                if (this.method_5642() != null) {
                    ClientPlayNetworking.send((class_8710)new SonicCyclePositionC2SPayload(this.method_23317(), this.method_23318(), this.method_23321(), this.prevYawVelocity, this.yawVelocity, this.usingSpeedBoost));
                    ClientPlayNetworking.send((class_8710)new SonicCycleVelocityC2SPayload(this.method_18798().field_1352, this.method_18798().field_1351, this.method_18798().field_1350));
                }
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
        } else {
            this.method_18799(class_243.field_1353);
        }
        this.updatePastPositions();
        this.createSonicBoomTrail();
        this.createSmokeParticlesWhenSpeedBoost();
        this.checkSonicBoomCollisions();
        this.method_5852();
    }

    public static enum Location {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

