/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimateTPA;

import de.scholle.ultimateTPA.TPARequest;
import de.scholle.ultimateTPA.UltimateTPA;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TPACommand
implements CommandExecutor {
    private final UltimateTPA plugin;

    public TPACommand(UltimateTPA plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage("\u00a7cUsage: /tpa <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage("\u00a7cPlayer not found.");
            return true;
        }
        TPARequest request = new TPARequest(player, target, false);
        this.plugin.getRequests().put(target.getUniqueId(), request);
        target.sendMessage(this.plugin.getLanguageManager().get(target, "tpa_request").replace("%player%", player.getName()));
        TextComponent accept = new TextComponent(this.plugin.getLanguageManager().get(target, "tpa_accept"));
        accept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept"));
        TextComponent deny = new TextComponent(this.plugin.getLanguageManager().get(target, "tpa_deny"));
        deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny"));
        target.spigot().sendMessage(new BaseComponent[]{accept, new TextComponent(" "), deny});
        player.sendMessage(this.plugin.getLanguageManager().get(player, "tpa_sent").replace("%player%", target.getName()));
        if (this.plugin.getConfig().getBoolean("sound.enabled")) {
            target.playSound(target.getLocation(), Sound.valueOf((String)this.plugin.getConfig().getString("sound.request")), 1.0f, 1.0f);
        }
        return true;
    }
}

