/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimateTPA;

import de.scholle.ultimateTPA.TPARequest;
import de.scholle.ultimateTPA.UltimateTPA;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TPAAcceptCommand
implements CommandExecutor {
    private final UltimateTPA plugin;

    public TPAAcceptCommand(UltimateTPA plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player receiver = (Player)sender;
        TPARequest request = this.plugin.getRequests().remove(receiver.getUniqueId());
        if (request == null) {
            receiver.sendMessage(this.plugin.getLanguageManager().get(receiver, "tpa_no_request"));
            return true;
        }
        if (request.isExpired(this.plugin.getConfig().getLong("request-expire-time") * 1000L)) {
            receiver.sendMessage(this.plugin.getLanguageManager().get(receiver, "tpa_expired"));
            return true;
        }
        Player senderP = request.sender;
        if (!senderP.isOnline()) {
            receiver.sendMessage(this.plugin.getLanguageManager().get(receiver, "tpa_sender_offline"));
            return true;
        }
        int delay = this.plugin.getConfig().getInt("teleport-delay");
        boolean cancelOnMove = this.plugin.getConfig().getBoolean("cancel-on-move");
        receiver.sendMessage(this.plugin.getLanguageManager().get(receiver, "tpa_accepted"));
        senderP.sendMessage(this.plugin.getLanguageManager().get(senderP, "tpa_accepted_by").replace("%player%", receiver.getName()).replace("%seconds%", String.valueOf(delay)));
        request.teleporting = true;
        if (this.plugin.getConfig().getBoolean("sound.enabled")) {
            senderP.playSound(senderP.getLocation(), Sound.valueOf((String)this.plugin.getConfig().getString("sound.accept")), 1.0f, 1.0f);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (cancelOnMove && senderP.getLocation().distanceSquared(request.senderLocation) > 0.1) {
                senderP.sendMessage(this.plugin.getLanguageManager().get(senderP, "tpa_move_cancel"));
                request.teleporting = false;
                return;
            }
            if (request.here) {
                senderP.teleport(receiver.getLocation());
            } else {
                receiver.teleport(senderP.getLocation());
            }
            senderP.sendMessage(this.plugin.getLanguageManager().get(senderP, "tpa_teleported"));
        }, (long)delay * 20L);
        return true;
    }
}

