/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimateTPA;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.scholle.ultimateTPA.UltimateTPA;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Player;

public class LanguageManager {
    private final UltimateTPA plugin;
    private final Map<String, JsonObject> languages = new HashMap<String, JsonObject>();

    public LanguageManager(UltimateTPA plugin) {
        this.plugin = plugin;
        this.loadLanguages();
    }

    private void loadLanguages() {
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        for (File file : Objects.requireNonNull(langFolder.listFiles())) {
            if (!file.getName().endsWith(".json")) continue;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                this.languages.put(file.getName().replace(".json", ""), json);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load language file: " + file.getName());
            }
        }
    }

    public String get(Player player, String key) {
        String locale = player.getLocale();
        JsonObject lang = this.languages.getOrDefault(locale, this.languages.get("en_US"));
        if (lang != null && lang.has(key)) {
            return this.format(this.plugin.getConfig().getString("prefix") + lang.get(key).getAsString());
        }
        return this.format(this.plugin.getConfig().getString("prefix") + key);
    }

    private String format(String msg) {
        return msg.replace("&", "\u00a7");
    }
}

