/*
 * Decompiled with CFR 0.152.
 */
package me.kcra.takenaka.accessor.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.kcra.takenaka.accessor.mapping.ConstructorMapping;
import me.kcra.takenaka.accessor.mapping.FieldMapping;
import me.kcra.takenaka.accessor.mapping.MethodMapping;
import me.kcra.takenaka.accessor.platform.MapperPlatform;
import me.kcra.takenaka.accessor.platform.MapperPlatforms;
import me.kcra.takenaka.accessor.util.NameDescriptorPair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMapping {
    private final String name;
    private final Map<String, Map<String, String>> mappings;
    private final Map<String, List<FieldMapping>> fields;
    private final List<ConstructorMapping> constructors;
    private final Map<String, List<MethodMapping>> methods;

    public ClassMapping(@NotNull String name, @NotNull Map<String, Map<String, String>> mappings, @NotNull Map<String, ?> fields, @NotNull List<ConstructorMapping> constructors, @NotNull Map<String, List<MethodMapping>> methods) {
        this.name = name;
        this.mappings = mappings;
        this.constructors = constructors;
        this.methods = methods;
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof FieldMapping)) continue;
            ArrayList<FieldMapping> mappings1 = new ArrayList<FieldMapping>();
            mappings1.add((FieldMapping)value);
            entry.setValue(mappings1);
        }
        this.fields = fields;
    }

    public ClassMapping(@NotNull String name) {
        this(name, new HashMap<String, Map<String, String>>(), new HashMap(), new ArrayList<ConstructorMapping>(), new HashMap<String, List<MethodMapping>>());
    }

    @Nullable
    public Map<String, String> getMappings(@NotNull String version) {
        return this.mappings.get(version);
    }

    @Nullable
    public String getName(@NotNull String version, String ... namespaces) {
        Map<String, String> versionMappings = this.getMappings(version);
        if (versionMappings == null) {
            return null;
        }
        for (String namespace : namespaces) {
            String name = versionMappings.get(namespace);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Nullable
    public Class<?> getClass(@NotNull ClassLoader loader, @NotNull String version, String ... namespaces) {
        String name = this.getName(version, namespaces);
        if (name == null) {
            return null;
        }
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Nullable
    public Class<?> getClass(@NotNull String version, String ... namespaces) {
        return this.getClass(Thread.currentThread().getContextClassLoader(), version, namespaces);
    }

    @Nullable
    public Class<?> getClass(@NotNull MapperPlatform platform) {
        return this.getClass(platform.getClassLoader(), platform.getVersion(), platform.getMappingNamespaces());
    }

    @Nullable
    public Class<?> getClazz() {
        return this.getClass(MapperPlatforms.getCurrentPlatform());
    }

    @Nullable
    public FieldMapping getField(@NotNull String name) {
        return this.getField(name, 0);
    }

    @Nullable
    public FieldMapping getField(@NotNull String name, int index) {
        List<FieldMapping> overloads = this.fields.get(name);
        if (overloads == null) {
            return null;
        }
        if (index < 0 || index >= overloads.size()) {
            return null;
        }
        return overloads.get(index);
    }

    @Nullable
    public FieldMapping remapField(@NotNull String version, @NotNull String namespace, @NotNull String name) {
        for (List<FieldMapping> overloads : this.fields.values()) {
            for (FieldMapping field : overloads) {
                if (!name.equals(field.getName(version, namespace))) continue;
                return field;
            }
        }
        return null;
    }

    @Nullable
    public ConstructorMapping getConstructor(int index) {
        if (index < 0 || index >= this.constructors.size()) {
            return null;
        }
        return this.constructors.get(index);
    }

    @Nullable
    public MethodMapping getMethod(@NotNull String name, int index) {
        List<MethodMapping> overloads = this.methods.get(name);
        if (overloads == null) {
            return null;
        }
        if (index < 0 || index >= overloads.size()) {
            return null;
        }
        return overloads.get(index);
    }

    @Nullable
    public MethodMapping remapMethod(@NotNull String version, @NotNull String namespace, @NotNull NameDescriptorPair namePair) {
        for (List<MethodMapping> overloads : this.methods.values()) {
            for (MethodMapping method : overloads) {
                if (!namePair.equals(method.getName(version, namespace))) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public MethodMapping remapMethod(@NotNull String version, @NotNull String namespace, @NotNull String name, String ... parameters) {
        return this.remapMethod(version, namespace, new NameDescriptorPair(name, parameters));
    }

    @ApiStatus.Internal
    @Contract(value="_, _, _ -> this")
    @NotNull
    public ClassMapping put(@NotNull String namespace, @NotNull String mapping, String ... versions) {
        for (String version : versions) {
            this.mappings.computeIfAbsent(version, k -> new HashMap()).put(namespace, mapping);
        }
        return this;
    }

    @ApiStatus.Internal
    @Contract(value="_, _ -> this")
    @NotNull
    public ClassMapping putField(@NotNull String name, @NotNull Consumer<FieldMapping> builder) {
        List overloads = this.fields.computeIfAbsent(name, k -> new ArrayList());
        FieldMapping mapping = new FieldMapping(this, name, overloads.size());
        builder.accept(mapping);
        overloads.add(mapping);
        return this;
    }

    @ApiStatus.Internal
    @Contract(value="_ -> this")
    @NotNull
    public ClassMapping putConstructor(@NotNull Consumer<ConstructorMapping> builder) {
        ConstructorMapping mapping = new ConstructorMapping(this, this.constructors.size());
        builder.accept(mapping);
        this.constructors.add(mapping);
        return this;
    }

    @ApiStatus.Internal
    @Contract(value="_, _ -> this")
    @NotNull
    public ClassMapping putMethod(@NotNull String name, @NotNull Consumer<MethodMapping> builder) {
        List overloads = this.methods.computeIfAbsent(name, k -> new ArrayList());
        MethodMapping mapping = new MethodMapping(this, name, overloads.size());
        builder.accept(mapping);
        overloads.add(mapping);
        return this;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Map<String, Map<String, String>> getMappings() {
        return this.mappings;
    }

    @Deprecated
    @NotNull
    public Map<String, FieldMapping> getFields() {
        return this.fields.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (FieldMapping)((List)e.getValue()).get(0)));
    }

    @NotNull
    public Map<String, List<FieldMapping>> getOverloadedFields() {
        return this.fields;
    }

    @NotNull
    public List<ConstructorMapping> getConstructors() {
        return this.constructors;
    }

    @NotNull
    public Map<String, List<MethodMapping>> getMethods() {
        return this.methods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassMapping that = (ClassMapping)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.fields, that.fields) && Objects.equals(this.constructors, that.constructors) && Objects.equals(this.methods, that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.mappings, this.fields, this.constructors, this.methods);
    }

    public String toString() {
        return "ClassMapping{name='" + this.name + '\'' + ", mappings=" + this.mappings + ", fields=" + this.fields + ", constructors=" + this.constructors + ", methods=" + this.methods + '}';
    }
}

