/*
 * Decompiled with CFR 0.152.
 */
package me.kcra.takenaka.accessor.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.kcra.takenaka.accessor.mapping.ClassMapping;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingLookup {
    private final Map<String, ClassMapping> mappings;

    public MappingLookup() {
        this(new HashMap<String, ClassMapping>());
    }

    public MappingLookup(@NotNull Map<String, ClassMapping> mappings) {
        this.mappings = mappings;
    }

    @Nullable
    public ClassMapping getClass(@NotNull String name) {
        return this.mappings.get(name);
    }

    @Nullable
    public ClassMapping remapClass(@NotNull String version, @NotNull String namespace, @NotNull String name) {
        for (ClassMapping clazz : this.mappings.values()) {
            if (!name.equals(clazz.getName(version, namespace))) continue;
            return clazz;
        }
        return null;
    }

    @ApiStatus.Internal
    @Contract(value="_ -> this")
    @NotNull
    public MappingLookup put(@NotNull ClassMapping mapping) {
        this.mappings.put(mapping.getName(), mapping);
        return this;
    }

    @NotNull
    public Map<String, ClassMapping> getMappings() {
        return this.mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingLookup that = (MappingLookup)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    public String toString() {
        return "MappingLookup{mappings=" + this.mappings + '}';
    }
}

