/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft;

import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.config.ConfigBuilder;
import org.vivecraft.debug.Debug;

public class PermissionManager {
    private static Permission PERMISSIONS = null;

    public static boolean checkForVault() {
        boolean available;
        boolean bl = available = Bukkit.getServer().getPluginManager().getPlugin("Vault") != null && Bukkit.getServer().getPluginManager().getPlugin("Vault").isEnabled();
        if (!available) {
            return false;
        }
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp == null) {
            return false;
        }
        PERMISSIONS = (Permission)rsp.getProvider();
        if (PERMISSIONS == null) {
            ViveMain.LOGGER.severe("Permissions error: Registered permissions provider is null!");
            return false;
        }
        if (!PERMISSIONS.hasGroupSupport()) {
            ViveMain.LOGGER.severe("Permissions error: Permission plugin does not support groups.");
            PERMISSIONS = null;
        }
        return PERMISSIONS != null;
    }

    private static boolean isDisabled() {
        return PERMISSIONS == null || (Boolean)ViveMain.CONFIG.permissionsGroupsEnabled.get() == false;
    }

    public static void changeGroupName(String from, String to) {
        if (PermissionManager.isDisabled()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!PERMISSIONS.playerInGroup(player, from)) continue;
            PERMISSIONS.playerRemoveGroup(player, from);
            PERMISSIONS.playerAddGroup(player, from);
        }
    }

    public static void updatePlayerPermissionGroup(Player player) {
        if (PermissionManager.isDisabled()) {
            return;
        }
        VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
        if (vivePlayer == null) {
            PermissionManager.setVR(player, false);
            PermissionManager.setNonVR(player, false);
        } else {
            PermissionManager.setVR(player, vivePlayer.isVR());
            PermissionManager.setNonVR(player, !vivePlayer.isVR());
        }
    }

    private static void setVR(Player player, boolean add) {
        PermissionManager.setGroup(player, add, ViveMain.CONFIG.permissionsVRGroup);
    }

    private static void setNonVR(Player player, boolean add) {
        PermissionManager.setGroup(player, add, ViveMain.CONFIG.permissionsNonVRGroup);
    }

    private static void setGroup(Player player, boolean add, ConfigBuilder.StringValue group) {
        String groupString = (String)group.get();
        if (groupString.trim().isEmpty()) {
            Debug.log("Not setting %s group because it is empty!", group.getPath());
        }
        if (add && !PERMISSIONS.playerInGroup(player, groupString)) {
            Debug.log("Adding player '%s' to %s group", player.getName(), group.getPath());
            if (!PERMISSIONS.playerAddGroup(player, groupString)) {
                ViveMain.LOGGER.info("Couldn't add " + player.getName() + " to group " + groupString + ". Group may not exist!");
            }
        } else if (!add && PERMISSIONS.playerInGroup(player, groupString)) {
            Debug.log("Removing player '%s' from %s group", player.getName(), group.getPath());
            if (!PERMISSIONS.playerRemoveGroup(player, groupString)) {
                ViveMain.LOGGER.info("Couldn't remove " + player.getName() + " from group " + groupString + ". Group may not exist!");
            }
        }
    }
}

