/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft;

import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api_impl.VRAPIImpl;
import org.vivecraft.data.VrPlayerState;
import org.vivecraft.network.NetworkConstants;
import org.vivecraft.network.NetworkVersion;
import org.vivecraft.util.ItemOverride;
import org.vivecraft.util.MCVersion;
import org.vivecraft.util.MathUtils;
import org.vivecraft.util.MetadataHelper;

public class VivePlayer {
    @Nullable
    private VrPlayerState vrPlayerState;
    private VRPose vrPlayerStateAsPose;
    public float draw;
    public float worldScale = 1.0f;
    public float heightScale = 1.0f;
    public VRBodyPart activeBodyPart = VRBodyPart.MAIN_HAND;
    public ItemOverride itemOverride = null;
    public boolean useBodyPartForAim = false;
    public boolean crawling;
    private boolean isVR = false;
    public Vector offset = new Vector();
    public Player player;
    public NetworkVersion networkVersion = NetworkVersion.fromProtocolVersion(NetworkConstants.MAX_SUPPORTED_NETWORK_PROTOCOL);
    public String version = "none";
    public boolean wantsDamageDirection = false;
    public String channel = "none";
    public MCVersion mcVersion = MCVersion.INVALID;

    public VivePlayer(Player player) {
        this.player = player;
    }

    public Quaternionfc getBodyPartOrientation(VRBodyPart bodyPart) {
        if (this.vrPlayerState != null) {
            if (this.isSeated() || !bodyPart.availableInMode(this.vrPlayerState.fbtMode)) {
                bodyPart = VRBodyPart.MAIN_HAND;
            }
            return this.vrPlayerState.getBodyPartPose((VRBodyPart)bodyPart).orientation;
        }
        return new Quaternionf().lookAlong(MathUtils.toJomlVec(this.player.getLocation().getDirection()), MathUtils.UP);
    }

    public Vector3fc getBodyPartVectorCustom(VRBodyPart bodyPart, Vector3fc direction) {
        if (this.vrPlayerState != null) {
            if (this.isSeated() || !bodyPart.availableInMode(this.vrPlayerState.fbtMode)) {
                bodyPart = VRBodyPart.MAIN_HAND;
            }
            return this.vrPlayerState.getBodyPartPose((VRBodyPart)bodyPart).orientation.transform(direction, new Vector3f());
        }
        return MathUtils.toJomlVec(this.player.getLocation().getDirection());
    }

    public Vector3fc getBodyPartDir(VRBodyPart bodyPart) {
        return this.getBodyPartVectorCustom(bodyPart, MathUtils.BACK);
    }

    public Vector3fc getAimDir(boolean ignoreUseForAim) {
        if (!this.isSeated() && this.draw > 0.0f) {
            return MathUtils.subToJomlVec(this.getBodyPartPos(this.activeBodyPart.opposite()), this.getBodyPartPos(this.activeBodyPart)).normalize();
        }
        if (ignoreUseForAim || this.useBodyPartForAim) {
            return this.getBodyPartDir(this.activeBodyPart);
        }
        return this.getBodyPartDir(VRBodyPart.MAIN_HAND);
    }

    public Quaternionfc getAimOrientation(boolean ignoreUseForAim) {
        if (!this.isSeated() && this.draw > 0.0f) {
            return new Quaternionf().lookAlong(this.getAimDir(ignoreUseForAim), this.getBodyPartVectorCustom(this.activeBodyPart.opposite(), MathUtils.GRIP_FORWARD)).conjugate();
        }
        if (ignoreUseForAim || this.useBodyPartForAim) {
            return this.getBodyPartOrientation(this.activeBodyPart);
        }
        return this.getBodyPartOrientation(VRBodyPart.MAIN_HAND);
    }

    public Vector getAimPos(boolean ignoreUseForAim) {
        if (ignoreUseForAim || this.useBodyPartForAim) {
            return this.getBodyPartPos(this.activeBodyPart);
        }
        return this.getBodyPartPos(VRBodyPart.MAIN_HAND);
    }

    public Quaternionfc getAimRot(boolean ignoreUseForAim) {
        if (ignoreUseForAim || this.useBodyPartForAim) {
            return this.getBodyPartOrientation(this.activeBodyPart);
        }
        return this.getBodyPartOrientation(VRBodyPart.MAIN_HAND);
    }

    public Vector3fc getHMDDir() {
        if (this.vrPlayerState != null) {
            return this.vrPlayerState.hmd.orientation.transform(MathUtils.BACK, new Vector3f());
        }
        return MathUtils.toJomlVec(this.player.getLocation().getDirection());
    }

    public Vector getHMDPos() {
        Vector playerPos = this.player.getLocation().toVector();
        if (this.vrPlayerState != null) {
            return MathUtils.toBukkitVec(this.vrPlayerState.hmd.position).add(this.offset).add(playerPos);
        }
        return new Vector(0.0, 1.62, 0.0).add(playerPos);
    }

    public Vector getBodyPartPos(VRBodyPart bodyPart, boolean realPosition) {
        Vector playerPos = this.player.getLocation().toVector();
        if (this.vrPlayerState != null) {
            if (!bodyPart.availableInMode(this.vrPlayerState.fbtMode)) {
                bodyPart = VRBodyPart.MAIN_HAND;
            }
            if (this.isSeated() && bodyPart.isHand() && !realPosition) {
                Vector3f dir = this.getHMDDir().rotateY((float)Math.PI / 180 * (bodyPart == VRBodyPart.MAIN_HAND ? -35.0f : 35.0f), new Vector3f());
                dir.y = 0.0f;
                dir = dir.normalize();
                Vector pos = this.getHMDPos();
                pos.setX(pos.getX() + (double)(dir.x * 0.3f * this.worldScale));
                pos.setY(pos.getY() + (double)(-0.4f * this.worldScale));
                pos.setZ(pos.getZ() + (double)(dir.z * 0.3f * this.worldScale));
                return pos;
            }
            Vector3fc conPos = this.vrPlayerState.getBodyPartPose((VRBodyPart)bodyPart).position;
            return playerPos.add(this.offset).add(MathUtils.toBukkitVec(conPos));
        }
        return new Vector(0.0, 1.62, 0.0).add(playerPos);
    }

    public Vector getBodyPartPos(VRBodyPart bodyPart) {
        return this.getBodyPartPos(bodyPart, false);
    }

    public boolean isVR() {
        return this.isVR;
    }

    public void setVR(boolean vr) {
        this.isVR = vr;
    }

    public boolean isSeated() {
        return this.vrPlayerState != null && this.vrPlayerState.seated;
    }

    public boolean isLeftHanded() {
        return this.vrPlayerState != null && this.vrPlayerState.leftHanded;
    }

    @Nullable
    public VrPlayerState vrPlayerState() {
        return this.vrPlayerState;
    }

    public void setVrPlayerState(VrPlayerState vrPlayerState) {
        this.vrPlayerState = vrPlayerState;
        this.vrPlayerStateAsPose = null;
        Vector pos = this.player.getLocation().toVector();
        VRAPIImpl.INSTANCE.addPoseToHistory(this.player.getUniqueId(), vrPlayerState.asVRPose(pos), pos);
        MetadataHelper.updateMetadata(this);
    }

    public VRPose asVRPose() {
        if (this.vrPlayerState == null) {
            return null;
        }
        if (this.vrPlayerStateAsPose == null) {
            this.vrPlayerStateAsPose = this.vrPlayerState.asVRPose(this.player.getLocation().toVector());
        }
        return this.vrPlayerStateAsPose;
    }
}

