/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.compat;

import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.ViveMain;
import org.vivecraft.compat.Scheduler;
import org.vivecraft.compat_impl.BukkitPlatform;

public abstract class Platform {
    public static final boolean FOLIA = Platform.isFolia();
    private static Platform INSTANCE;
    private final Scheduler scheduler;

    public Platform(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public static Platform getInstance() {
        if (INSTANCE == null) {
            if (FOLIA) {
                try {
                    ViveMain.LOGGER.info("running on folia");
                    INSTANCE = (Platform)Class.forName("org.vivecraft.compat_impl.FoliaPlatform").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Vivecraft: failed to get folia scheduler", e);
                }
            } else {
                INSTANCE = new BukkitPlatform();
            }
        }
        return INSTANCE;
    }

    private static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public abstract void teleportEntity(Entity var1, Location var2, @Nullable Vector var3);
}

