/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.config;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.network.NetworkHandler;
import org.vivecraft.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.util.Utils;

public class ConfigBuilder {
    private FileConfiguration config;
    private final Deque<String> stack = new ArrayDeque<String>();
    private final List<ConfigValue> configValues = new ArrayList<ConfigValue>();
    private final Map<String, ConfigValue> map = new HashMap<String, ConfigValue>();

    public ConfigBuilder(FileConfiguration config) {
        this.config = config;
    }

    public int setNewConfigFile(FileConfiguration newConfig, boolean withUpdate, @NotNull Consumer<String> notifier) {
        this.config = newConfig;
        int changes = 0;
        for (ConfigValue configValue : this.configValues) {
            Object oldValue = configValue.get();
            configValue.reload();
            Object newValue = configValue.get();
            if (this.checktSingle(configValue, notifier)) {
                ++changes;
                configValue.reset(notifier);
                continue;
            }
            if (Objects.equals(oldValue, newValue)) continue;
            ++changes;
            notifier.accept(ViveMain.translate("vivecraft command.reload.changed", configValue.path, Utils.green(oldValue), Utils.green(newValue)));
            if (!withUpdate) continue;
            configValue.set(newValue, notifier);
        }
        return changes;
    }

    protected FileConfiguration getConfig() {
        return this.config;
    }

    @Nullable
    public ConfigValue getConfigValue(String key) {
        return this.map.get(key);
    }

    private void registerConfigValue(String key, ConfigValue configValue) {
        if (this.map.containsKey(key)) {
            throw new IllegalStateException("Duplicate config key: " + key);
        }
        this.map.put(key, configValue);
        this.configValues.add(configValue);
    }

    public ConfigBuilder push(String subPath) {
        this.stack.add(subPath);
        return this;
    }

    public ConfigBuilder pop() {
        this.stack.removeLast();
        return this;
    }

    public void correct(@NotNull Consumer<String> listener) {
        for (ConfigValue configValue : this.configValues) {
            if (!this.checktSingle(configValue, listener)) continue;
            configValue.reset(configValue.getRaw() == null ? null : listener);
        }
    }

    protected boolean checktSingle(ConfigValue configValue, @NotNull Consumer<String> listener) {
        InListValue listValue;
        if (configValue.getRaw() == null) {
            return true;
        }
        if (configValue instanceof NumberValue) {
            if (!(configValue.getRaw() instanceof Number)) {
                listener.accept(ViveMain.translate("vivecraft.command.invalid", Utils.red(configValue.getRaw()), configValue.getPath()));
                return true;
            }
            NumberValue numberValue = (NumberValue)configValue;
            Number val = (Number)numberValue.get();
            if (val.doubleValue() < ((Number)numberValue.getMin()).doubleValue() || val.doubleValue() > ((Number)numberValue.getMax()).doubleValue()) {
                listener.accept(ViveMain.translate("vivecraft.command.number.outOfRange", Utils.red(val), Utils.green(numberValue.getMin()), Utils.green(numberValue.getMax()), numberValue.getPath()));
                return true;
            }
        } else if (configValue instanceof InListValue && !(listValue = (InListValue)configValue).getValidValues().contains(listValue.get())) {
            listener.accept(ViveMain.translate("vivecraft.command.invalid", Utils.red(listValue.get()), listValue.getPath()));
            return true;
        }
        return false;
    }

    public List<ConfigValue> getConfigValues() {
        return this.configValues;
    }

    public <T> ConfigValue<T> define(T defaultValue) {
        String path = String.join((CharSequence)".", this.stack);
        this.config.addDefault(path, defaultValue);
        this.stack.removeLast();
        ConfigValue<T> value = new ConfigValue<T>(this, path, defaultValue);
        this.registerConfigValue(path, value);
        return value;
    }

    public <T extends Comparable<? super T>> ConfigValue<T> defineInRange(T defaultValue, T min, T max) {
        String path = String.join((CharSequence)".", this.stack);
        this.stack.removeLast();
        ConfigValue<T> value = new ConfigValue<T>(this, path, defaultValue);
        this.registerConfigValue(path, value);
        return value;
    }

    public <T> ListValue<T> defineList(List<T> defaultValue) {
        String path = String.join((CharSequence)".", this.stack);
        this.stack.removeLast();
        ListValue<T> value = new ListValue<T>(this, path, defaultValue);
        this.registerConfigValue(path, value);
        return value;
    }

    public StringListValue defineStringList(List<String> defaultValue) {
        String path = String.join((CharSequence)".", this.stack);
        this.stack.removeLast();
        StringListValue value = new StringListValue(this, path, defaultValue);
        this.registerConfigValue(path, value);
        return value;
    }

    public <T> InListValue<T> defineInList(T defaultValue, Collection<? extends T> validValues) {
        String path = String.join((CharSequence)".", this.stack);
        this.stack.removeLast();
        InListValue<? extends T> value = new InListValue<T>(this, path, defaultValue, validValues);
        this.registerConfigValue(path, value);
        return value;
    }

    public <T extends Enum<T>> EnumValue<T> defineEnum(T defaultValue, Class<T> enumClass) {
        String path = String.join((CharSequence)".", this.stack);
        EnumValue<T> value = new EnumValue<T>(this, path, defaultValue, enumClass);
        this.stack.removeLast();
        this.registerConfigValue(path, value);
        return value;
    }

    public BooleanValue define(boolean defaultValue) {
        String path = String.join((CharSequence)".", this.stack);
        this.stack.removeLast();
        BooleanValue value = new BooleanValue(this, path, defaultValue);
        this.registerConfigValue(path, value);
        return value;
    }

    public StringValue define(String defaultValue) {
        String path = String.join((CharSequence)".", this.stack);
        this.stack.removeLast();
        StringValue value = new StringValue(this, path, defaultValue);
        this.registerConfigValue(path, value);
        return value;
    }

    public DoubleValue defineInRange(double defaultValue, double min, double max) {
        String path = String.join((CharSequence)".", this.stack);
        this.stack.removeLast();
        DoubleValue value = new DoubleValue(this, path, defaultValue, min, max);
        this.registerConfigValue(path, value);
        return value;
    }

    public IntValue defineInRange(int defaultValue, int min, int max) {
        String path = String.join((CharSequence)".", this.stack);
        this.stack.removeLast();
        IntValue value = new IntValue(this, path, defaultValue, min, max);
        this.registerConfigValue(path, value);
        return value;
    }

    public static class ConfigValue<T> {
        protected final ConfigBuilder config;
        protected final String path;
        protected final T defaultValue;
        protected T cachedValue = null;
        protected boolean needsReload;
        protected T clientDefaultValue;
        private BiFunction<T, VivePlayer, VivecraftPayloadS2C> packetFunction = null;
        private UpdateNotifier<T> updateConsumer = null;

        public ConfigValue(ConfigBuilder config, String path, T defaultValue) {
            this.config = config;
            this.path = path;
            this.defaultValue = defaultValue;
        }

        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.getFromConfig();
            }
            return this.cachedValue;
        }

        protected T getFromConfig() {
            return (T)this.config.getConfig().get(this.path);
        }

        protected T getRaw() {
            return (T)this.config.getConfig().get(this.path);
        }

        public void set(T newValue, @Nullable Consumer<String> notifier) {
            T oldValue = this.getRaw();
            this.cachedValue = newValue;
            this.config.getConfig().set(this.path, newValue);
            if (oldValue != null) {
                this.onUpdate(oldValue, newValue, notifier);
            }
        }

        public T reset(@Nullable Consumer<String> notifier) {
            this.set(this.defaultValue, notifier);
            if (notifier != null) {
                notifier.accept(ViveMain.translate("vivecraft.command.configReset", this.path, Utils.green(this.defaultValue)));
            }
            return this.defaultValue;
        }

        public void reload() {
            this.cachedValue = null;
            this.get();
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDefault() {
            return Objects.equals(this.get(), this.getDefaultValue());
        }

        public String getPath() {
            return this.path;
        }

        public <V extends ConfigValue<T>> V setOnUpdate(UpdateNotifier<T> onUpdate) {
            this.updateConsumer = onUpdate;
            return (V)this;
        }

        public void onUpdate(T oldValue, T newValue, @Nullable Consumer<String> notifier) {
            if (this.updateConsumer != null) {
                this.updateConsumer.onUpdate(oldValue, newValue, notifier);
            }
            NetworkHandler.sendUpdatePacketToAll(this, notifier);
        }

        public <V extends ConfigValue<T>> V setPacketFunction(BiFunction<T, VivePlayer, VivecraftPayloadS2C> supplier) {
            this.packetFunction = supplier;
            return (V)this;
        }

        @Nullable
        public BiFunction<T, VivePlayer, VivecraftPayloadS2C> getPacketFunction() {
            return this.packetFunction;
        }

        public <V extends ConfigValue<T>> V setNeedsReload(boolean needsReload) {
            this.needsReload = needsReload;
            return (V)this;
        }

        public boolean needsReload() {
            return this.needsReload;
        }

        public <V extends ConfigValue<T>> V setClientDefault(T clientDefaultValue) {
            this.clientDefaultValue = clientDefaultValue;
            return (V)this;
        }

        public boolean isClientDefault() {
            return this.clientDefaultValue != null ? Objects.equals(this.get(), this.clientDefaultValue) : this.isDefault();
        }
    }

    public static abstract class NumberValue<E extends Number>
    extends ConfigValue<E> {
        private final E min;
        private final E max;

        public NumberValue(ConfigBuilder config, String path, E defaultValue, E min, E max) {
            super(config, path, defaultValue);
            this.min = min;
            this.max = max;
        }

        public E getMin() {
            return this.min;
        }

        public E getMax() {
            return this.max;
        }
    }

    public static class InListValue<T>
    extends ConfigValue<T> {
        private final Collection<? extends T> validValues;

        public InListValue(ConfigBuilder config, String path, T defaultValue, Collection<? extends T> validValues) {
            super(config, path, defaultValue);
            this.validValues = validValues;
        }

        public Collection<? extends T> getValidValues() {
            return this.validValues;
        }
    }

    public static class ListValue<T>
    extends ConfigValue<List<T>> {
        public ListValue(ConfigBuilder config, String path, List<T> defaultValue) {
            super(config, path, defaultValue);
        }

        @Override
        protected List<T> getFromConfig() {
            return this.config.getConfig().getList(this.path);
        }
    }

    public static class StringListValue
    extends ListValue<String> {
        public StringListValue(ConfigBuilder config, String path, List<String> defaultValue) {
            super(config, path, defaultValue);
        }

        @Override
        protected List<String> getFromConfig() {
            return this.config.getConfig().getStringList(this.path);
        }
    }

    public static class EnumValue<T extends Enum<T>>
    extends ConfigValue<T> {
        private final Class<T> enumClass;

        public EnumValue(ConfigBuilder config, String path, T defaultValue, Class<T> enumClass) {
            super(config, path, defaultValue);
            this.enumClass = enumClass;
        }

        @Override
        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.getEnumValue(this.getFromConfig());
            }
            return (T)((Enum)this.cachedValue);
        }

        @Override
        public void set(T newValue, Consumer<String> notifier) {
            Object oldValue = this.getRaw();
            this.cachedValue = newValue;
            this.config.getConfig().set(this.path, (Object)((Enum)newValue).name());
            if (oldValue != null) {
                this.onUpdate(oldValue, newValue, notifier);
            }
        }

        @Override
        protected T getRaw() {
            return this.getEnumValue(this.config.getConfig().get(this.path));
        }

        public T getEnumValue(Object value) {
            if (value != null) {
                Class<?> cls = value.getClass();
                if (this.enumClass.isAssignableFrom(cls)) {
                    return (T)((Enum)value);
                }
                if (cls == String.class) {
                    String name = (String)value;
                    for (Enum item : (Enum[])this.enumClass.getEnumConstants()) {
                        if (!item.name().equalsIgnoreCase(name)) continue;
                        return (T)item;
                    }
                    ViveMain.LOGGER.severe("No enum constant " + this.enumClass.getCanonicalName() + "." + name);
                } else {
                    ViveMain.LOGGER.severe("Cannot convert a value of type " + cls.getCanonicalName() + " to an Enum " + this.enumClass.getCanonicalName());
                }
            }
            return null;
        }

        public Collection<? extends T> getValidValues() {
            return EnumSet.allOf(this.enumClass);
        }
    }

    public static class BooleanValue
    extends ConfigValue<Boolean> {
        public BooleanValue(ConfigBuilder config, String path, boolean defaultValue) {
            super(config, path, defaultValue);
        }

        @Override
        protected Boolean getFromConfig() {
            return this.config.getConfig().getBoolean(this.path);
        }
    }

    public static class StringValue
    extends ConfigValue<String> {
        public StringValue(ConfigBuilder config, String path, String defaultValue) {
            super(config, path, defaultValue);
        }

        @Override
        protected String getFromConfig() {
            return this.config.getConfig().getString(this.path);
        }
    }

    public static class DoubleValue
    extends NumberValue<Double> {
        public DoubleValue(ConfigBuilder config, String path, double defaultValue, double min, double max) {
            super(config, path, defaultValue, min, max);
        }

        @Override
        protected Double getFromConfig() {
            return this.config.getConfig().getDouble(this.path);
        }
    }

    public static class IntValue
    extends NumberValue<Integer> {
        public IntValue(ConfigBuilder config, String path, int defaultValue, int min, int max) {
            super(config, path, defaultValue, min, max);
        }

        @Override
        protected Integer getFromConfig() {
            return this.config.getConfig().getInt(this.path);
        }
    }

    @FunctionalInterface
    public static interface SimpleUpdateNotifier<T>
    extends SingleUpdateNotifier<T> {
        public void onUpdate(T var1);

        @Override
        default public void onUpdate(T newValue, @Nullable Consumer<String> notifier) {
            this.onUpdate(newValue);
        }
    }

    @FunctionalInterface
    public static interface SingleUpdateNotifier<T>
    extends UpdateNotifier<T> {
        public void onUpdate(T var1, @Nullable Consumer<String> var2);

        @Override
        default public void onUpdate(T oldValue, T newValue, @Nullable Consumer<String> notifier) {
            this.onUpdate(newValue, notifier);
        }
    }

    @FunctionalInterface
    public static interface UpdateNotifier<T> {
        public void onUpdate(T var1, T var2, @Nullable Consumer<String> var3);
    }
}

