/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.events;

import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.debug.Debug;
import org.vivecraft.network.NetworkHandler;
import org.vivecraft.network.packet.s2c.DamageDirectionPayloadS2C;
import org.vivecraft.util.AABB;
import org.vivecraft.util.MathUtils;

public class DamageEvents
implements Listener {
    @EventHandler
    public void onPvP(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Entity entity = event.getDamager();
        Player other = null;
        if (entity instanceof Player) {
            other = (Player)entity;
        } else if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Player) {
            other = (Player)((Projectile)entity).getShooter();
        }
        if (other != null) {
            VivePlayer otherVive = ViveMain.getVivePlayer((Entity)other);
            VivePlayer thisVive = ViveMain.getVivePlayer((Entity)((Player)event.getEntity()));
            if (otherVive == null) {
                otherVive = new VivePlayer(other);
            }
            if (thisVive == null) {
                thisVive = new VivePlayer((Player)event.getEntity());
            }
            boolean blockedDamage = false;
            String blockedDamageCase = "";
            if (!otherVive.isVR() && thisVive.isVR() && thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && otherVive.isSeated()) {
                if (!((Boolean)ViveMain.CONFIG.pvpSeatedvrVsNonvr.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = ViveMain.translate("vivecraft.pvp.canceled", ViveMain.translate("vivecraft.mode.nonVR", new Object[0]), ViveMain.translate("vivecraft.mode.seatedVR", new Object[0]));
                }
            } else if (!otherVive.isVR() && thisVive.isVR() && !thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ViveMain.CONFIG.pvpVrVsNonvr.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = ViveMain.translate("vivecraft.pvp.canceled", ViveMain.translate("vivecraft.mode.nonVR", new Object[0]), ViveMain.translate("vivecraft.mode.standingVR", new Object[0]));
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated() || thisVive.isVR() && thisVive.isSeated() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ViveMain.CONFIG.pvpVrVsSeatedvr.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = ViveMain.translate("vivecraft.pvp.canceled", ViveMain.translate("vivecraft.mode.seatedVR", new Object[0]), ViveMain.translate("vivecraft.mode.standingVR", new Object[0]));
                }
            } else if (otherVive.isVR() && !otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated()) {
                if (!((Boolean)ViveMain.CONFIG.pvpVrVsVr.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = ViveMain.translate("vivecraft.pvp.canceled", ViveMain.translate("vivecraft.mode.standingVR", new Object[0]), ViveMain.translate("vivecraft.mode.standingVR", new Object[0]));
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && thisVive.isSeated() && !((Boolean)ViveMain.CONFIG.pvpSeatedvrVsSeatedvr.get()).booleanValue()) {
                blockedDamage = true;
                blockedDamageCase = ViveMain.translate("vivecraft.pvp.canceled", ViveMain.translate("vivecraft.mode.seatedVR", new Object[0]), ViveMain.translate("vivecraft.mode.seatedVR", new Object[0]));
            }
            if (blockedDamage) {
                if (((Boolean)ViveMain.CONFIG.pvpNotifyBlockedDamage.get()).booleanValue()) {
                    other.sendMessage(blockedDamageCase);
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void noAttackWhileBlocking(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getDamager() instanceof Player && ViveMain.isVRPlayer(event.getDamager()) && (player = (Player)event.getDamager()).isBlocking() && !((Boolean)ViveMain.CONFIG.allowAttacksWhileBlocking.get()).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void bootsDamage(EntityDamageByEntityEvent event) {
        if (((Boolean)ViveMain.CONFIG.dualWielding.get()).booleanValue() && (Double)ViveMain.CONFIG.bootsArmorDamage.get() > 0.0 && event.getDamager() instanceof Player && ViveMain.isVRPlayer(event.getDamager())) {
            Player player = (Player)event.getDamager();
            VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
            ItemStack itemStack = player.getEquipment().getBoots();
            if (vivePlayer.activeBodyPart.isFoot() && itemStack != null && itemStack.getType() != Material.AIR) {
                double armor = ViveMain.API.applyArmorModifiers(ViveMain.NMS.getArmorValue(itemStack), player.getInventory().getBoots());
                double addedDamage = armor * (Double)ViveMain.CONFIG.bootsArmorDamage.get();
                Debug.log("Boots hit: armor level: %s, total damage added: %s", armor, addedDamage);
                event.setDamage(event.getDamage() + addedDamage);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void roomscaleBlocking(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && ViveMain.isVRPlayer(event.getEntity()) && ((Boolean)ViveMain.CONFIG.allowRoomscaleShieldBlocking.get()).booleanValue() && !(player = (Player)event.getEntity()).isBlocking()) {
            Entity damage = event.getDamager();
            VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
            boolean isProjectile = false;
            if (damage instanceof Projectile) {
                isProjectile = true;
                if (damage instanceof Arrow && ViveMain.API.isArrowPiercing((Arrow)damage)) {
                    return;
                }
            }
            AABB bb = ViveMain.API.getEntityAABB(damage);
            Vector dmgPos = bb.getCenter().subtract(damage.getVelocity().normalize());
            for (int i = 0; i < 2; ++i) {
                Vector dmgDir;
                VRBodyPart hand = i == 0 ? VRBodyPart.MAIN_HAND : VRBodyPart.OFF_HAND;
                ItemStack stack = ViveMain.API.getHandItem(player, hand);
                if (stack == null || !ViveMain.API.isShield(stack) || ViveMain.API.hasItemCooldown(player, stack)) continue;
                Vector3fc sideDir = vivePlayer.isLeftHanded() ? (hand == VRBodyPart.MAIN_HAND ? MathUtils.RIGHT : MathUtils.LEFT) : (hand == VRBodyPart.MAIN_HAND ? MathUtils.LEFT : MathUtils.RIGHT);
                Vector3fc shieldDir = vivePlayer.getBodyPartVectorCustom(hand, sideDir);
                double angle = 0.0;
                if (isProjectile) {
                    dmgDir = dmgPos.subtract(vivePlayer.getBodyPartPos(hand)).normalize();
                    angle = shieldDir.dot((float)dmgDir.getX(), (float)dmgDir.getY(), (float)dmgDir.getZ());
                } else {
                    dmgDir = dmgPos.subtract(player.getLocation().toVector()).setY(0).normalize();
                    Vector3f hShieldDir = new Vector3f(shieldDir.x(), 0.0f, shieldDir.z()).normalize();
                    angle = hShieldDir.dot((float)dmgDir.getX(), (float)dmgDir.getY(), (float)dmgDir.getZ());
                }
                if (!(angle > 0.5)) continue;
                if (event.getDamage() >= 3.0 && ViveMain.API.addDamage(stack, 1 + (int)Math.floor(event.getDamage()))) {
                    ViveMain.API.breakItem(player, hand);
                }
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void damageDirection(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player && ViveMain.isVRPlayer(event.getEntity())) {
            VivePlayer vivePlayer = ViveMain.getVivePlayer(event.getEntity());
            if (vivePlayer.wantsDamageDirection) {
                Vector3fc direction = MathUtils.ZERO;
                switch (event.getCause()) {
                    case FALLING_BLOCK: {
                        direction = MathUtils.UP;
                        break;
                    }
                    case FALL: {
                        direction = MathUtils.DOWN;
                        break;
                    }
                    case PROJECTILE: 
                    case ENTITY_ATTACK: {
                        if (!(event instanceof EntityDamageByEntityEvent)) break;
                        direction = MathUtils.subToJomlVec(((EntityDamageByEntityEvent)event).getDamager().getLocation().toVector(), event.getEntity().getLocation().toVector()).normalize();
                    }
                }
                NetworkHandler.sendPacket(vivePlayer, new DamageDirectionPayloadS2C(direction));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void reducedMeleeRange(EntityDamageByEntityEvent event) {
        Player player;
        VivePlayer vivePlayer;
        if (event.getEntity() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && (Double)ViveMain.CONFIG.mobAttackRangeAdjustment.get() < 0.0 && (vivePlayer = ViveMain.getVivePlayer((Entity)(player = (Player)event.getEntity()))) != null && vivePlayer.isVR() && !vivePlayer.isSeated() && !ViveMain.NMS.inReducedAttackRange(player, event.getDamager())) {
            event.setCancelled(true);
        }
    }
}

