/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.events;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.util.Vector;
import org.joml.Vector3fc;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.compat.Platform;
import org.vivecraft.util.MathUtils;

public class EntityEvents
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void makeVrCompatible(CreatureSpawnEvent event) {
        if (!event.isCancelled()) {
            Platform.getInstance().getScheduler().runEntityDelayed((Entity)event.getEntity(), () -> {
                if (event.getEntity().isValid()) {
                    ViveMain.NMS.modifyEntity((Entity)event.getEntity());
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (ViveMain.isVRPlayer((Entity)event.getPlayer()) && event.getPlayer().isValid()) {
            VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)event.getPlayer());
            Item item = event.getItemDrop();
            Location location = item.getLocation();
            Vector pos = vivePlayer.getAimPos(false);
            location.setX(pos.getX());
            location.setY(pos.getY() - (double)(ViveMain.API.getEntityHeight((Entity)item) * 0.5f));
            location.setZ(pos.getZ());
            Vector3fc aim = vivePlayer.getAimDir(false);
            Vector velocity = MathUtils.toBukkitVec(aim).multiply(item.getVelocity().length());
            location.add(velocity);
            Platform.getInstance().teleportEntity((Entity)item, location, velocity);
        }
    }
}

