/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.events;

import java.util.Random;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.vivecraft.PermissionManager;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.compat.Platform;
import org.vivecraft.compat.types.Item;
import org.vivecraft.debug.Debug;
import org.vivecraft.network.AimFixHandler;
import org.vivecraft.network.NetworkUtils;
import org.vivecraft.util.MetadataHelper;
import org.vivecraft.util.UpdateChecker;

public class PlayerEvents
implements Listener {
    private final Random random = new Random();

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        ViveMain.VIVE_PLAYERS.remove(player.getUniqueId());
        MetadataHelper.cleanupMetadata(player);
        if (((Boolean)ViveMain.CONFIG.messagesEnabled.get()).booleanValue() && !((String)ViveMain.CONFIG.messagesLeaveMessage.get()).isEmpty()) {
            NetworkUtils.sendMessageToAll((String)ViveMain.CONFIG.messagesLeaveMessage.get(), player.getDisplayName(), "");
        }
    }

    @EventHandler
    public void onPlayerConnect(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Debug.log(player.getName() + " has joined the server", new Object[0]);
        Debug.log("Waiting for Vivecraft info of: " + player.getName(), new Object[0]);
        Platform.getInstance().getScheduler().runGlobalDelayed(() -> {
            if (player.isOnline()) {
                VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
                String message = "";
                if (NetworkUtils.kickIfNotAllowed(player)) {
                    return;
                }
                if (vivePlayer == null) {
                    Debug.log(player.getName() + " joined without vivecraft", new Object[0]);
                }
                if (((Boolean)ViveMain.CONFIG.messagesEnabled.get()).booleanValue()) {
                    message = vivePlayer == null ? (String)ViveMain.CONFIG.messagesWelcomeVanilla.get() : (!vivePlayer.isVR() ? (String)ViveMain.CONFIG.messagesWelcomeNonvr.get() : (vivePlayer.isSeated() ? (String)ViveMain.CONFIG.messagesWelcomeSeated.get() : (String)ViveMain.CONFIG.messagesWelcomeVr.get()));
                    NetworkUtils.sendMessageToAll(message, player.getDisplayName(), "");
                }
                PermissionManager.updatePlayerPermissionGroup(player);
            } else {
                Debug.log(player.getName() + " no longer online!", new Object[0]);
            }
        }, ((Integer)ViveMain.CONFIG.messageKickDelay.get()).intValue());
        if (((Boolean)ViveMain.CONFIG.checkForUpdates.get()).booleanValue() && player.isOp()) {
            UpdateChecker.scheduleUpdateCheck(arg_0 -> ((Player)player).sendMessage(arg_0));
        }
        new AimFixHandler(player, ViveMain.NMS.getConnection(player));
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        VivePlayer vivePlayer;
        if (((Boolean)ViveMain.CONFIG.vrFun.get()).booleanValue() && ViveMain.isVivePlayer((Entity)event.getPlayer()) && (vivePlayer = ViveMain.getVivePlayer((Entity)event.getPlayer())).isVR() && this.random.nextInt(40) == 3) {
            ItemStack easterEggItem = this.random.nextInt(2) == 1 ? ViveMain.API.createItemStack(Item.PUMPKIN_PIE, null, "EAT ME", null) : ViveMain.API.createItemStack(Item.WATER_POTION, null, "DRINK ME", null);
            event.getPlayer().getInventory().addItem(new ItemStack[]{easterEggItem});
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (((Boolean)ViveMain.CONFIG.messagesEnabled.get()).booleanValue()) {
            VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)event.getEntity());
            String message = "";
            String entity = ViveMain.API.getCausingEntityName(event);
            if (!entity.isEmpty()) {
                message = vivePlayer == null ? (String)ViveMain.CONFIG.messagesDeathByMobVanilla.get() : (!vivePlayer.isVR() ? (String)ViveMain.CONFIG.messagesDeathByMobNonvr.get() : (vivePlayer.isSeated() ? (String)ViveMain.CONFIG.messagesDeathByMobSeated.get() : (String)ViveMain.CONFIG.messagesDeathByMobVr.get()));
            }
            if (message.isEmpty()) {
                message = vivePlayer == null ? (String)ViveMain.CONFIG.messagesDeathVanilla.get() : (!vivePlayer.isVR() ? (String)ViveMain.CONFIG.messagesDeathNonvr.get() : (vivePlayer.isSeated() ? (String)ViveMain.CONFIG.messagesDeathSeated.get() : (String)ViveMain.CONFIG.messagesDeathVr.get()));
            }
            if (!message.isEmpty()) {
                event.setDeathMessage(NetworkUtils.formatMessage(message, event.getEntity().getDisplayName(), entity));
            }
        }
    }
}

