/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.linker;

import java.util.logging.Level;
import org.vivecraft.ViveMain;
import org.vivecraft.compat.ApiHelper;
import org.vivecraft.compat.McHelper;
import org.vivecraft.compat.NMSHelper;
import org.vivecraft.util.MCVersion;

public class Helpers {
    public static ApiHelper getApi() {
        return (ApiHelper)Helpers.getHelper("org.vivecraft.compat_impl.mc_%s.Api_%s");
    }

    public static McHelper getMc() {
        return (McHelper)Helpers.getHelper("org.vivecraft.compat_impl.mc_%s.Mc_%s");
    }

    public static NMSHelper getNMS() {
        return (NMSHelper)Helpers.getHelper("org.vivecraft.compat_impl.mc_%s.NMS_%s");
    }

    public static Object getHelper(String classTemplate) {
        MCVersion mc = MCVersion.getCurrentCorrected();
        int minor = mc.minor;
        for (int major = mc.major; major > 7; --major) {
            while (minor >= 0) {
                String compatVersion = minor == 0 ? "1_" + major : "1_" + major + "_" + minor;
                try {
                    Class<?> helperClass = Class.forName(String.format(classTemplate, compatVersion, compatVersion));
                    try {
                        return helperClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        ViveMain.LOGGER.log(Level.SEVERE, "could not instantiate " + helperClass.getName(), e);
                        throw new RuntimeException(e);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    --minor;
                }
            }
            minor = 10;
        }
        throw new RuntimeException("Couldn't find any compatible class for " + classTemplate);
    }
}

