/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.PermissionManager;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.compat.BukkitReflector;
import org.vivecraft.compat.Platform;
import org.vivecraft.config.ConfigBuilder;
import org.vivecraft.data.Pose;
import org.vivecraft.data.VrPlayerState;
import org.vivecraft.debug.Debug;
import org.vivecraft.network.NetworkConstants;
import org.vivecraft.network.NetworkUtils;
import org.vivecraft.network.NetworkVersion;
import org.vivecraft.network.PacketUtils;
import org.vivecraft.network.packet.PayloadIdentifier;
import org.vivecraft.network.packet.c2s.ActiveBodyPartPayloadC2S;
import org.vivecraft.network.packet.c2s.CrawlPayloadC2S;
import org.vivecraft.network.packet.c2s.DrawPayloadC2S;
import org.vivecraft.network.packet.c2s.HeightPayloadC2S;
import org.vivecraft.network.packet.c2s.LegacyController0DataPayloadC2S;
import org.vivecraft.network.packet.c2s.LegacyController1DataPayloadC2S;
import org.vivecraft.network.packet.c2s.LegacyHeadDataPayloadC2S;
import org.vivecraft.network.packet.c2s.TeleportPayloadC2S;
import org.vivecraft.network.packet.c2s.UnknownPayloadC2S;
import org.vivecraft.network.packet.c2s.VRActivePayloadC2S;
import org.vivecraft.network.packet.c2s.VRPlayerStatePayloadC2S;
import org.vivecraft.network.packet.c2s.VersionPayloadC2S;
import org.vivecraft.network.packet.c2s.VivecraftPayloadC2S;
import org.vivecraft.network.packet.c2s.WorldScalePayloadC2S;
import org.vivecraft.network.packet.s2c.CrawlPayloadS2C;
import org.vivecraft.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.network.packet.s2c.HapticPayloadS2C;
import org.vivecraft.network.packet.s2c.NetworkVersionPayloadS2C;
import org.vivecraft.network.packet.s2c.RequestDataPayloadS2C;
import org.vivecraft.network.packet.s2c.ServerVrChangesS2CPacket;
import org.vivecraft.network.packet.s2c.SettingOverridePayloadS2C;
import org.vivecraft.network.packet.s2c.TeleportPayloadS2C;
import org.vivecraft.network.packet.s2c.UberPacketPayloadS2C;
import org.vivecraft.network.packet.s2c.VRActivePayloadS2C;
import org.vivecraft.network.packet.s2c.VersionPayloadS2C;
import org.vivecraft.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.util.ItemOverride;
import org.vivecraft.util.LazySupplier;
import org.vivecraft.util.MetadataHelper;
import org.vivecraft.util.Utils;

public class NetworkHandler
implements PluginMessageListener {
    private static JavaPlugin PLUGIN;
    private final Map<UUID, Map<PayloadIdentifier, VivecraftPayloadC2S>> legacyDataMap = new HashMap<UUID, Map<PayloadIdentifier, VivecraftPayloadC2S>>();

    public NetworkHandler(JavaPlugin plugin) {
        PLUGIN = plugin;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        VivecraftPayloadC2S payload = VivecraftPayloadC2S.readPacket(new DataInputStream(new ByteArrayInputStream(message)));
        if (payload instanceof UnknownPayloadC2S) {
            return;
        }
        VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
        if (vivePlayer == null && payload.payloadId() != PayloadIdentifier.VERSION) {
            return;
        }
        if (vivePlayer != null) {
            vivePlayer.player = player;
        }
        switch (payload.payloadId()) {
            case VERSION: {
                this.handleVersion(player, channel, (VersionPayloadC2S)payload);
                break;
            }
            case IS_VR_ACTIVE: {
                this.handleIsActive(vivePlayer, (VRActivePayloadC2S)payload);
                break;
            }
            case DRAW: {
                vivePlayer.draw = ((DrawPayloadC2S)payload).draw;
                break;
            }
            case VR_PLAYER_STATE: {
                vivePlayer.setVrPlayerState(((VRPlayerStatePayloadC2S)payload).playerState);
                break;
            }
            case WORLDSCALE: {
                vivePlayer.worldScale = ((WorldScalePayloadC2S)payload).worldScale;
                break;
            }
            case HEIGHT: {
                vivePlayer.heightScale = ((HeightPayloadC2S)payload).heightScale;
                break;
            }
            case TELEPORT: {
                this.handleTeleport(vivePlayer, (TeleportPayloadC2S)payload);
                break;
            }
            case CLIMBING: {
                this.handleClimbing(vivePlayer);
                break;
            }
            case ACTIVEHAND: {
                this.handleActiveHand(vivePlayer, (ActiveBodyPartPayloadC2S)payload);
                break;
            }
            case CRAWL: {
                this.handleCrawl(vivePlayer, (CrawlPayloadC2S)payload);
                break;
            }
            case DAMAGE_DIRECTION: {
                vivePlayer.wantsDamageDirection = true;
                break;
            }
            case CONTROLLER0DATA: 
            case CONTROLLER1DATA: 
            case HEADDATA: {
                this.handleLegacyData(vivePlayer, payload);
                break;
            }
            default: {
                throw new IllegalStateException("Vivecraft: got unexpected packet on server: " + (Object)((Object)payload.payloadId()));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleVersion(Player player, String channel, VersionPayloadC2S version) {
        VivePlayer vivePlayer;
        block17: {
            vivePlayer = new VivePlayer(player);
            vivePlayer.channel = channel;
            vivePlayer.version = version.version;
            vivePlayer.mcVersion = Utils.getMCVersion(vivePlayer.version);
            Debug.log("player '%s' joined with vivecraft '%s' on MC '%s'", player.getName(), vivePlayer.version, vivePlayer.mcVersion);
            if (!version.legacy) {
                if (NetworkConstants.MIN_SUPPORTED_NETWORK_PROTOCOL <= version.maxVersion && version.minVersion <= NetworkConstants.MAX_SUPPORTED_NETWORK_PROTOCOL) {
                    vivePlayer.networkVersion = NetworkVersion.fromProtocolVersion(Math.min(version.maxVersion, NetworkConstants.MAX_SUPPORTED_NETWORK_PROTOCOL));
                    Debug.log("%s networking supported, using version %s", new Object[]{player.getName(), vivePlayer.networkVersion});
                    break block17;
                } else {
                    player.sendMessage("Unsupported vivecraft version, VR features will not work");
                    Debug.log("%s networking not supported. client range [%s,%s], server range [%s,%s]", player.getName(), version.minVersion, version.maxVersion, NetworkConstants.MIN_SUPPORTED_NETWORK_PROTOCOL, NetworkConstants.MAX_SUPPORTED_NETWORK_PROTOCOL);
                    return;
                }
            }
            vivePlayer.networkVersion = NetworkVersion.LEGACY;
            Debug.log("%s using legacy networking", player.getName());
        }
        vivePlayer.setVR(version.vr);
        ViveMain.VIVE_PLAYERS.put(player.getUniqueId(), vivePlayer);
        NetworkHandler.sendPacket(vivePlayer, new VersionPayloadS2C(ViveMain.VERSION));
        if (((Boolean)ViveMain.CONFIG.requestData.get()).booleanValue()) {
            NetworkHandler.sendPacket(vivePlayer, new RequestDataPayloadS2C());
        }
        if (((Boolean)ViveMain.CONFIG.climbeyEnabled.get()).booleanValue()) {
            NetworkHandler.sendPacket(vivePlayer, PacketUtils.getClimbeyServerPayload(vivePlayer));
        }
        if (((Boolean)ViveMain.CONFIG.teleportEnabled.get()).booleanValue() || NetworkVersion.OPTION_TOGGLE.accepts(vivePlayer.networkVersion)) {
            NetworkHandler.sendPacket(vivePlayer, new TeleportPayloadS2C((Boolean)ViveMain.CONFIG.teleportEnabled.get(), vivePlayer.networkVersion));
        }
        if (((Boolean)ViveMain.CONFIG.teleportLimitedSurvival.get()).booleanValue()) {
            NetworkHandler.sendPacket(vivePlayer, PacketUtils.getSurvivalTeleportOverridePayload());
        }
        if (((Boolean)ViveMain.CONFIG.worldscaleLimited.get()).booleanValue()) {
            NetworkHandler.sendPacket(vivePlayer, PacketUtils.getWorldScaleOverridePayload());
        }
        if (((Boolean)ViveMain.CONFIG.forceThirdPersonItems.get()).booleanValue()) {
            NetworkHandler.sendPacket(vivePlayer, PacketUtils.getThirdPersonItemsOverridePayload());
        }
        if (((Boolean)ViveMain.CONFIG.forceThirdPersonItemsCustom.get()).booleanValue()) {
            NetworkHandler.sendPacket(vivePlayer, PacketUtils.getThirdPersonItemsCustomOverridePayload());
        }
        if (ViveMain.MC.supportsCrawling()) {
            if (vivePlayer.isVR()) {
                ViveMain.NMS.addCrawlPoseWrapper(vivePlayer.player);
            }
            if (((Boolean)ViveMain.CONFIG.crawlingEnabled.get()).booleanValue()) {
                NetworkHandler.sendPacket(vivePlayer, new CrawlPayloadS2C(true, vivePlayer.networkVersion));
            }
        }
        NetworkHandler.sendPacket(vivePlayer, PacketUtils.getVRSwitchingPayload());
        if (NetworkVersion.DUAL_WIELDING.accepts(vivePlayer.networkVersion)) {
            NetworkHandler.sendPacket(vivePlayer, new DualWieldingPayloadS2C((Boolean)ViveMain.CONFIG.dualWielding.get()));
        }
        if (NetworkVersion.SERVER_VR_CHANGES.accepts(vivePlayer.networkVersion)) {
            HashMap<String, String> settings = new HashMap<String, String>();
            for (ConfigBuilder.ConfigValue config : ViveMain.CONFIG.getConfigValues()) {
                if (!config.getPath().startsWith("vrChanges") || config.isClientDefault()) continue;
                settings.put(config.getPath(), String.valueOf(config.get()));
            }
            if (!settings.isEmpty()) {
                NetworkHandler.sendPacket(vivePlayer, new ServerVrChangesS2CPacket(settings));
            }
        }
        NetworkHandler.sendPacket(vivePlayer, new NetworkVersionPayloadS2C(vivePlayer.networkVersion));
    }

    private void handleIsActive(VivePlayer vivePlayer, VRActivePayloadC2S active) {
        if (vivePlayer.isVR() == active.vr) {
            return;
        }
        vivePlayer.setVR(!vivePlayer.isVR());
        PermissionManager.updatePlayerPermissionGroup(vivePlayer.player);
        if (!vivePlayer.isVR()) {
            NetworkHandler.sendPacketToTrackingPlayers(vivePlayer, new VRActivePayloadS2C(false, vivePlayer.player.getUniqueId()));
            MetadataHelper.cleanupMetadata(vivePlayer.player);
        } else if (ViveMain.MC.supportsCrawling()) {
            ViveMain.NMS.addCrawlPoseWrapper(vivePlayer.player);
        }
    }

    private void handleTeleport(VivePlayer vivePlayer, TeleportPayloadC2S teleport) {
        if (!((Boolean)ViveMain.CONFIG.teleportEnabled.get()).booleanValue()) {
            return;
        }
        Location loc = vivePlayer.player.getLocation();
        loc.setX((double)teleport.x);
        loc.setY((double)teleport.y);
        loc.setZ((double)teleport.z);
        Platform.getInstance().teleportEntity((Entity)vivePlayer.player, loc, null);
    }

    private void handleClimbing(VivePlayer vivePlayer) {
        if (!((Boolean)ViveMain.CONFIG.climbeyEnabled.get()).booleanValue()) {
            return;
        }
        ViveMain.NMS.resetFallDistance(vivePlayer.player);
    }

    private void handleActiveHand(VivePlayer vivePlayer, ActiveBodyPartPayloadC2S activeBodypart) {
        VRBodyPart newBodyPart = activeBodypart.bodyPart;
        if (vivePlayer.isSeated() && newBodyPart != VRBodyPart.HEAD) {
            newBodyPart = VRBodyPart.MAIN_HAND;
        }
        vivePlayer.useBodyPartForAim = activeBodypart.useForAim;
        if (vivePlayer.activeBodyPart != newBodyPart && ((Boolean)ViveMain.CONFIG.dualWielding.get()).booleanValue() && NetworkVersion.DUAL_WIELDING.accepts(vivePlayer.networkVersion)) {
            if (vivePlayer.itemOverride != null) {
                ItemStack newItem;
                Object newNmsItem = ViveMain.NMS.getHandItemInternal(vivePlayer.player, VRBodyPart.MAIN_HAND);
                if (!(ViveMain.NMS.itemStackMatch(vivePlayer.itemOverride.override, newNmsItem) || (newItem = BukkitReflector.asBukkitCopy(newNmsItem)) != null && newItem.getType() != Material.AIR)) {
                    ViveMain.API.breakItemEffects(vivePlayer.player, vivePlayer.itemOverride.overridePart, BukkitReflector.asBukkitCopy(vivePlayer.itemOverride.override));
                }
                ViveMain.NMS.setHandItemInternal(vivePlayer.player, vivePlayer.itemOverride.overridePart, ViveMain.NMS.getHandItemInternal(vivePlayer.player, VRBodyPart.MAIN_HAND));
                ViveMain.NMS.setHandItemInternal(vivePlayer.player, VRBodyPart.MAIN_HAND, vivePlayer.itemOverride.original);
                ViveMain.NMS.applyEquipmentChange(vivePlayer.player, vivePlayer.itemOverride.override, vivePlayer.itemOverride.original);
                vivePlayer.itemOverride = null;
            }
            if (newBodyPart != VRBodyPart.MAIN_HAND) {
                vivePlayer.itemOverride = new ItemOverride(newBodyPart, ViveMain.NMS.getHandItemInternal(vivePlayer.player, VRBodyPart.MAIN_HAND), ViveMain.NMS.getItemStackCopy(ViveMain.NMS.getHandItemInternal(vivePlayer.player, newBodyPart)));
            }
            vivePlayer.activeBodyPart = newBodyPart;
            ViveMain.NMS.applyEquipmentChange(vivePlayer.player, ViveMain.NMS.getHandItemInternal(vivePlayer.player, VRBodyPart.MAIN_HAND), ViveMain.NMS.getHandItemInternal(vivePlayer.player, newBodyPart));
            ViveMain.NMS.setHandItemInternal(vivePlayer.player, VRBodyPart.MAIN_HAND, ViveMain.NMS.getHandItemInternal(vivePlayer.player, newBodyPart));
        }
    }

    private void handleCrawl(VivePlayer vivePlayer, CrawlPayloadC2S crawl) {
        if (!ViveMain.MC.supportsCrawling() || !((Boolean)ViveMain.CONFIG.crawlingEnabled.get()).booleanValue()) {
            return;
        }
        vivePlayer.crawling = crawl.crawling;
        ViveMain.NMS.setSwimPose(vivePlayer.player);
    }

    private void handleLegacyData(VivePlayer vivePlayer, VivecraftPayloadC2S payload) {
        Map playerData = this.legacyDataMap.computeIfAbsent(vivePlayer.player.getUniqueId(), id -> new HashMap());
        playerData.put(payload.payloadId(), payload);
        if (playerData.size() == 3) {
            LegacyController0DataPayloadC2S controller0Data = (LegacyController0DataPayloadC2S)playerData.get((Object)PayloadIdentifier.CONTROLLER0DATA);
            LegacyController1DataPayloadC2S controller1Data = (LegacyController1DataPayloadC2S)playerData.get((Object)PayloadIdentifier.CONTROLLER1DATA);
            LegacyHeadDataPayloadC2S headData = (LegacyHeadDataPayloadC2S)playerData.get((Object)PayloadIdentifier.HEADDATA);
            Pose head = headData.hmdPose;
            Pose main = controller0Data.mainHand;
            Pose off = controller1Data.offHand;
            if (vivePlayer.mcVersion.major < 13) {
                Vector pos = vivePlayer.player.getLocation().toVector().multiply(-1.0);
                head = head.offset(pos);
                main = main.offset(pos);
                off = off.offset(pos);
            }
            vivePlayer.setVrPlayerState(new VrPlayerState(headData.seated, head, controller0Data.leftHanded, main, controller1Data.leftHanded, off, FBTMode.ARMS_ONLY, null, null, null, null, null, null, null));
            this.legacyDataMap.remove(vivePlayer.player.getUniqueId());
        }
    }

    public static void sendPacket(VivePlayer vivePlayer, VivecraftPayloadS2C payload) {
        if (PLUGIN == null) {
            ViveMain.LOGGER.warning("tried to send a packet before init: " + (Object)((Object)payload.payloadId()));
            return;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             DataOutputStream data = new DataOutputStream(out);){
            payload.write(data);
            vivePlayer.player.sendPluginMessage((Plugin)PLUGIN, vivePlayer.channel, out.toByteArray());
        }
        catch (IOException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "Failed to send packet: " + (Object)((Object)payload.payloadId()), e);
        }
    }

    public static void sendUpdatePacketToAll(ConfigBuilder.ConfigValue config, @Nullable Consumer<String> notifier) {
        BiFunction function = config.getPacketFunction();
        if (function != null) {
            boolean unsupported = false;
            for (VivePlayer vivePlayer : ViveMain.VIVE_PLAYERS.values()) {
                VivecraftPayloadS2C payload = function.apply(config.get(), vivePlayer);
                if (!NetworkVersion.OPTION_TOGGLE.accepts(vivePlayer.networkVersion) && (payload instanceof SettingOverridePayloadS2C && ((SettingOverridePayloadS2C)payload).clear || payload instanceof CrawlPayloadS2C && !((CrawlPayloadS2C)payload).allowed || payload instanceof TeleportPayloadS2C && !((TeleportPayloadS2C)payload).allowed)) {
                    if (((Boolean)ViveMain.CONFIG.kickPlayersOnSettingUpdate.get()).booleanValue()) {
                        vivePlayer.player.kickPlayer(ViveMain.translate("vivecraft.setting.kick", new Object[0]));
                        continue;
                    }
                    unsupported = true;
                    continue;
                }
                NetworkHandler.sendPacket(vivePlayer, payload);
            }
            if (unsupported && notifier != null) {
                notifier.accept(Utils.gold(ViveMain.translate("vivecraft.command.unsupportedClient", Utils.green(ViveMain.CONFIG.kickPlayersOnSettingUpdate.getPath()))));
            }
        }
    }

    public static void updateViveVROnly() {
        for (Player player : new ArrayList(Bukkit.getServer().getOnlinePlayers())) {
            NetworkUtils.kickIfNotAllowed(player);
        }
        for (VivePlayer vivePlayer : ViveMain.VIVE_PLAYERS.values()) {
            NetworkHandler.sendPacket(vivePlayer, PacketUtils.getVRSwitchingPayload());
        }
    }

    public static void sendHapticToClient(Player player, VRBodyPart bodyPart, float duration, float frequency, float amplitude, float delay) {
        VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
        if (vivePlayer != null && vivePlayer.isVR() && NetworkVersion.HAPTIC_PACKET.accepts(vivePlayer.networkVersion)) {
            NetworkHandler.sendPacket(vivePlayer, new HapticPayloadS2C(bodyPart, duration, frequency, amplitude, delay));
        }
    }

    public static void sendVrPlayerStateToClients(VivePlayer vivePlayer) {
        VrPlayerState state = vivePlayer.vrPlayerState();
        LazySupplier<UberPacketPayloadS2C> oldLegacy = new LazySupplier<UberPacketPayloadS2C>(() -> new UberPacketPayloadS2C(vivePlayer.player.getUniqueId(), new VrPlayerState(state, NetworkVersion.LEGACY, vivePlayer.player.getLocation().toVector()), vivePlayer.worldScale, vivePlayer.heightScale));
        LazySupplier<UberPacketPayloadS2C> legacy = new LazySupplier<UberPacketPayloadS2C>(() -> new UberPacketPayloadS2C(vivePlayer.player.getUniqueId(), new VrPlayerState(state, NetworkVersion.LEGACY, null), vivePlayer.worldScale, vivePlayer.heightScale));
        LazySupplier<UberPacketPayloadS2C> regular = new LazySupplier<UberPacketPayloadS2C>(() -> new UberPacketPayloadS2C(vivePlayer.player.getUniqueId(), state, vivePlayer.worldScale, vivePlayer.heightScale));
        NetworkHandler.sendPacketToTrackingPlayers(vivePlayer, (VivePlayer player) -> player.networkVersion == NetworkVersion.LEGACY ? (player.mcVersion.major < 16 ? (VivecraftPayloadS2C)oldLegacy.get() : (VivecraftPayloadS2C)legacy.get()) : (VivecraftPayloadS2C)regular.get());
    }

    private static void sendPacketToTrackingPlayers(VivePlayer vivePlayer, VivecraftPayloadS2C payload) {
        NetworkHandler.sendPacketToTrackingPlayers(vivePlayer, (VivePlayer v) -> payload);
    }

    private static void sendPacketToTrackingPlayers(VivePlayer vivePlayer, Function<VivePlayer, VivecraftPayloadS2C> packetProvider) {
        double distance = (vivePlayer.player.getServer().getViewDistance() + 1) * 16;
        distance *= distance;
        for (VivePlayer other : ViveMain.VIVE_PLAYERS.values()) {
            if (other == vivePlayer || !other.player.isOnline() || other.player.getWorld() != vivePlayer.player.getWorld() || !(vivePlayer.player.getLocation().distanceSquared(other.player.getLocation()) < distance)) continue;
            NetworkHandler.sendPacket(other, packetProvider.apply(vivePlayer));
        }
        if (((Boolean)ViveMain.CONFIG.sendDataToOwner.get()).booleanValue()) {
            NetworkHandler.sendPacket(vivePlayer, packetProvider.apply(vivePlayer));
        }
    }
}

