/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network.packet.c2s;

import java.io.DataInputStream;
import java.io.IOException;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.network.packet.PayloadIdentifier;
import org.vivecraft.network.packet.c2s.VivecraftPayloadC2S;

public final class ActiveBodyPartPayloadC2S
implements VivecraftPayloadC2S {
    public final VRBodyPart bodyPart;
    public final boolean useForAim;

    public ActiveBodyPartPayloadC2S(VRBodyPart bodyPart, boolean useForAim) {
        this.bodyPart = bodyPart;
        this.useForAim = useForAim;
    }

    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.ACTIVEHAND;
    }

    public static ActiveBodyPartPayloadC2S read(DataInputStream buffer) throws IOException {
        VRBodyPart bodyPart = VRBodyPart.values()[buffer.readByte()];
        boolean useForAim = false;
        if (buffer.available() > 0) {
            useForAim = buffer.readBoolean();
        }
        return new ActiveBodyPartPayloadC2S(bodyPart, useForAim);
    }
}

