/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network.packet.c2s;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import org.vivecraft.ViveMain;
import org.vivecraft.network.packet.PayloadIdentifier;
import org.vivecraft.network.packet.VivecraftPayload;
import org.vivecraft.network.packet.c2s.ActiveBodyPartPayloadC2S;
import org.vivecraft.network.packet.c2s.ClimbingPayloadC2S;
import org.vivecraft.network.packet.c2s.CrawlPayloadC2S;
import org.vivecraft.network.packet.c2s.DamageDirectionPayloadC2S;
import org.vivecraft.network.packet.c2s.DrawPayloadC2S;
import org.vivecraft.network.packet.c2s.HeightPayloadC2S;
import org.vivecraft.network.packet.c2s.LegacyController0DataPayloadC2S;
import org.vivecraft.network.packet.c2s.LegacyController1DataPayloadC2S;
import org.vivecraft.network.packet.c2s.LegacyHeadDataPayloadC2S;
import org.vivecraft.network.packet.c2s.TeleportPayloadC2S;
import org.vivecraft.network.packet.c2s.UnknownPayloadC2S;
import org.vivecraft.network.packet.c2s.VRActivePayloadC2S;
import org.vivecraft.network.packet.c2s.VRPlayerStatePayloadC2S;
import org.vivecraft.network.packet.c2s.VersionPayloadC2S;
import org.vivecraft.network.packet.c2s.WorldScalePayloadC2S;

public interface VivecraftPayloadC2S
extends VivecraftPayload {
    public static VivecraftPayloadC2S readPacket(DataInputStream buffer) {
        try {
            byte index = buffer.readByte();
            if (index < PayloadIdentifier.values().length) {
                PayloadIdentifier id = PayloadIdentifier.values()[index];
                switch (id) {
                    case VERSION: {
                        return VersionPayloadC2S.read(buffer);
                    }
                    case HEADDATA: {
                        return LegacyHeadDataPayloadC2S.read(buffer);
                    }
                    case CONTROLLER0DATA: {
                        return LegacyController0DataPayloadC2S.read(buffer);
                    }
                    case CONTROLLER1DATA: {
                        return LegacyController1DataPayloadC2S.read(buffer);
                    }
                    case WORLDSCALE: {
                        return WorldScalePayloadC2S.read(buffer);
                    }
                    case DRAW: {
                        return DrawPayloadC2S.read(buffer);
                    }
                    case TELEPORT: {
                        return TeleportPayloadC2S.read(buffer);
                    }
                    case CLIMBING: {
                        return new ClimbingPayloadC2S();
                    }
                    case HEIGHT: {
                        return HeightPayloadC2S.read(buffer);
                    }
                    case ACTIVEHAND: {
                        return ActiveBodyPartPayloadC2S.read(buffer);
                    }
                    case CRAWL: {
                        return CrawlPayloadC2S.read(buffer);
                    }
                    case IS_VR_ACTIVE: {
                        return VRActivePayloadC2S.read(buffer);
                    }
                    case VR_PLAYER_STATE: {
                        return VRPlayerStatePayloadC2S.read(buffer);
                    }
                    case DAMAGE_DIRECTION: {
                        return new DamageDirectionPayloadC2S();
                    }
                }
                ViveMain.LOGGER.severe("Got unexpected payload identifier on server: " + (Object)((Object)id));
                return new UnknownPayloadC2S();
            }
            ViveMain.LOGGER.severe("Got unknown payload identifier on server: " + index);
            return new UnknownPayloadC2S();
        }
        catch (IOException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "Error reading vivecraft packer: ", e);
            return new UnknownPayloadC2S();
        }
    }
}

