/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.util;

import java.util.List;
import java.util.concurrent.Callable;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.data.VrPlayerState;
import org.vivecraft.util.MathUtils;
import org.vivecraft.util.Pair;
import org.vivecraft.util.Utils;

public class MetadataHelper {
    private static final List<Pair<VRBodyPart, String>> METADATA_NAMES = Utils.ListOf(Pair.of(VRBodyPart.HEAD, "head"), Pair.of(VRBodyPart.MAIN_HAND, "righthand"), Pair.of(VRBodyPart.OFF_HAND, "lefthand"), Pair.of(VRBodyPart.RIGHT_FOOT, "rightfoot"), Pair.of(VRBodyPart.LEFT_FOOT, "leftfoot"), Pair.of(VRBodyPart.WAIST, "waist"), Pair.of(VRBodyPart.RIGHT_KNEE, "rightknee"), Pair.of(VRBodyPart.LEFT_KNEE, "leftknee"), Pair.of(VRBodyPart.RIGHT_ELBOW, "rightelbow"), Pair.of(VRBodyPart.LEFT_ELBOW, "leftelbow"));

    public static void updateMetadata(VivePlayer vivePlayer) {
        VrPlayerState state = vivePlayer.vrPlayerState();
        for (Pair<VRBodyPart, String> entry : METADATA_NAMES) {
            if (state != null && ((VRBodyPart)((Object)entry.left)).availableInMode(state.fbtMode)) {
                MetadataHelper.updateBodyPart(vivePlayer, ((VRBodyPart)((Object)entry.left)).isHand() && state.leftHanded ? ((VRBodyPart)((Object)entry.left)).opposite() : (VRBodyPart)((Object)entry.left), (String)entry.right);
                continue;
            }
            MetadataHelper.cleanupBodyPartMetadata(vivePlayer.player, (String)entry.right);
        }
        MetadataHelper.addOrInvalidateKey(vivePlayer, "seated", vivePlayer::isSeated);
        MetadataHelper.addOrInvalidateKey(vivePlayer, "height", () -> Float.valueOf(vivePlayer.heightScale));
        MetadataHelper.addOrInvalidateKey(vivePlayer, "lefthanded", vivePlayer::isLeftHanded);
        MetadataHelper.addOrInvalidateKey(vivePlayer, "activehand", () -> {
            switch (vivePlayer.activeBodyPart) {
                case MAIN_HAND: {
                    return vivePlayer.isLeftHanded() ? "left" : "right";
                }
                case OFF_HAND: {
                    return vivePlayer.isLeftHanded() ? "right" : "left";
                }
            }
            return vivePlayer.activeBodyPart.toString();
        });
    }

    public static void cleanupMetadata(Player player) {
        for (Pair<VRBodyPart, String> entry : METADATA_NAMES) {
            MetadataHelper.cleanupBodyPartMetadata(player, (String)entry.right);
        }
        player.removeMetadata("seated", (Plugin)ViveMain.INSTANCE);
        player.removeMetadata("height", (Plugin)ViveMain.INSTANCE);
        player.removeMetadata("lefthanded", (Plugin)ViveMain.INSTANCE);
        player.removeMetadata("activehand", (Plugin)ViveMain.INSTANCE);
    }

    private static void cleanupBodyPartMetadata(Player player, String key) {
        player.removeMetadata(key + ".pos", (Plugin)ViveMain.INSTANCE);
        player.removeMetadata(key + ".aim", (Plugin)ViveMain.INSTANCE);
        player.removeMetadata(key + ".dir", (Plugin)ViveMain.INSTANCE);
        player.removeMetadata(key + ".rot", (Plugin)ViveMain.INSTANCE);
    }

    private static void updateBodyPart(VivePlayer vivePlayer, VRBodyPart bodyPart, String key) {
        MetadataHelper.addOrInvalidateKey(vivePlayer, key + ".pos", () -> MetadataHelper.getLocation(vivePlayer, bodyPart));
        MetadataHelper.addOrInvalidateKey(vivePlayer, key + ".dir", () -> MathUtils.toBukkitVec(vivePlayer.getBodyPartDir(bodyPart)));
        MetadataHelper.addOrInvalidateKey(vivePlayer, key + ".rot", () -> {
            Quaternionfc quat = vivePlayer.getBodyPartOrientation(VRBodyPart.HEAD);
            return new float[]{quat.w(), quat.x(), quat.y(), quat.z()};
        });
        MetadataHelper.addOrInvalidateKey(vivePlayer, key + ".aim", () -> MetadataHelper.getVec3(vivePlayer.getBodyPartDir(bodyPart)));
    }

    private static void addOrInvalidateKey(VivePlayer vivePlayer, String key, Callable<Object> lazyValue) {
        if (!vivePlayer.player.hasMetadata(key)) {
            vivePlayer.player.setMetadata(key, (MetadataValue)new LazyMetadataValue((Plugin)ViveMain.INSTANCE, lazyValue));
        } else {
            MetadataValue value = vivePlayer.player.getMetadata(key).stream().filter(v -> v.getOwningPlugin() == ViveMain.INSTANCE).findFirst().orElseThrow(() -> new RuntimeException("someone messed with our metadata"));
            value.invalidate();
        }
    }

    private static Location getLocation(VivePlayer vivePlayer, VRBodyPart bodyPart) {
        Vector pos = vivePlayer.getBodyPartPos(bodyPart);
        Location loc = new Location(vivePlayer.player.getWorld(), pos.getX(), pos.getY(), pos.getZ());
        loc.setDirection(MathUtils.toBukkitVec(vivePlayer.getBodyPartDir(bodyPart)));
        return loc;
    }

    private static Object getVec3(Vector3fc dir) {
        return ViveMain.NMS.newVec3(dir.x(), dir.y(), dir.z());
    }
}

