/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Level;
import me.kcra.takenaka.accessor.mapping.ConstructorMapping;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.ViveMain;
import org.vivecraft.util.MCVersion;
import org.vivecraft.util.reflection.ClassGetter;

public class ReflectionConstructor {
    public final Constructor<?> constructor;

    private ReflectionConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    private static ReflectionConstructor getConstructor(Class<?> cls, Class<?> ... args) throws NoSuchMethodException {
        return new ReflectionConstructor(cls.getConstructor(args));
    }

    public static ReflectionConstructor getConstructor(ConstructorMapping ... mappings) {
        return ReflectionConstructor.getConstructor(true, mappings);
    }

    public static ReflectionConstructor getConstructor(boolean critical, ConstructorMapping ... mappings) {
        String nameSpace;
        Constructor<?> c = null;
        String[] stringArray = new String[]{"spigot", "mojang"};
        int n = stringArray.length;
        for (int i = 0; i < n && (c = ReflectionConstructor.getConstructor(nameSpace = stringArray[i], mappings)) == null; ++i) {
        }
        if (c == null) {
            if (critical) {
                throw new RuntimeException("Unsupported mc version: " + MCVersion.getCurrent() + ", no constructor  found for: " + mappings[0].getParent().getName());
            }
            return null;
        }
        c.setAccessible(true);
        return new ReflectionConstructor(c);
    }

    @Nullable
    private static Constructor<?> getConstructor(String namespace, ConstructorMapping ... mappings) {
        MCVersion mc = MCVersion.getCurrentCorrected();
        Constructor<?> c = null;
        for (ConstructorMapping mapping : mappings) {
            int minor = mc.minor;
            for (int major = mc.major; major > 7 && c == null; --major) {
                while (minor >= 0 && c == null) {
                    c = minor == 0 ? mapping.getConstructor("1." + major, namespace) : mapping.getConstructor("1." + major + "." + minor, namespace);
                    --minor;
                }
                minor = 10;
            }
            if (c != null || mc.major > 8) continue;
            c = mapping.getConstructor("1.8.8", namespace);
        }
        return c;
    }

    public static ReflectionConstructor getWithApi(String pre, String post, Class<?> ... args) {
        try {
            Class<?> c = ClassGetter.getWithApi(pre, post);
            return ReflectionConstructor.getConstructor(c, args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("couldn't find constructor " + pre + ".###." + post + " with args: " + Arrays.toString(args), e);
        }
    }

    public static ReflectionConstructor getCompat(String name, Class<?> ... args) {
        try {
            Class<?> c = ClassGetter.getCompat("org.vivecraft.compat_impl.mc_X_X." + name);
            return ReflectionConstructor.getConstructor(c, args);
        }
        catch (NoClassDefFoundError e) {
            if (!name.contains("mojang")) {
                return ReflectionConstructor.getCompat("mojang." + name, args);
            }
            throw e;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("couldn't find constructor matching org.vivecraft.compat_impl.mc_X_X." + name + " with args: " + Arrays.toString(args), e);
        }
    }

    public static ReflectionConstructor getRaw(String cls, Class<?> ... args) {
        try {
            return ReflectionConstructor.getConstructor(ClassGetter.getRaw(cls), args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("couldn't find constructor " + cls + " with args: " + Arrays.toString(args), e);
        }
    }

    public Object newInstance(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "couldn't create instance " + this.constructor.getClass().getName(), e);
            return null;
        }
    }
}

