/*
 * Decompiled with CFR 0.152.
 */
package me.kcra.takenaka.accessor.mapping;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import me.kcra.takenaka.accessor.mapping.ClassMapping;
import me.kcra.takenaka.accessor.platform.MapperPlatform;
import me.kcra.takenaka.accessor.platform.MapperPlatforms;
import me.kcra.takenaka.accessor.util.ExceptionUtil;
import me.kcra.takenaka.accessor.util.NameDescriptorPair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodMapping {
    private final ClassMapping parent;
    private final String name;
    private final int index;
    private final Map<String, Map<String, NameDescriptorPair>> mappings;

    public MethodMapping(@NotNull ClassMapping parent, @NotNull String name, int index) {
        this(parent, name, index, new HashMap<String, Map<String, NameDescriptorPair>>());
    }

    public MethodMapping(@NotNull ClassMapping parent, @NotNull String name, int index, @NotNull Map<String, Map<String, NameDescriptorPair>> mappings) {
        this.parent = parent;
        this.name = name;
        this.index = index;
        this.mappings = mappings;
    }

    @ApiStatus.Internal
    @Nullable
    public static Class<?> parseClass(@NotNull ClassLoader loader, @NotNull String name) {
        Class<Object> element;
        String elementType = name.replace("[]", "");
        int dimensions = (name.length() - elementType.length()) / 2;
        switch (elementType) {
            case "boolean": {
                element = Boolean.TYPE;
                break;
            }
            case "byte": {
                element = Byte.TYPE;
                break;
            }
            case "short": {
                element = Short.TYPE;
                break;
            }
            case "int": {
                element = Integer.TYPE;
                break;
            }
            case "long": {
                element = Long.TYPE;
                break;
            }
            case "float": {
                element = Float.TYPE;
                break;
            }
            case "double": {
                element = Double.TYPE;
                break;
            }
            case "char": {
                element = Character.TYPE;
                break;
            }
            case "void": {
                element = Void.TYPE;
                break;
            }
            default: {
                try {
                    element = Class.forName(elementType, true, loader);
                    break;
                }
                catch (ClassNotFoundException ignored) {
                    return null;
                }
            }
        }
        if (dimensions == 0) {
            return element;
        }
        return Array.newInstance(element, new int[dimensions]).getClass();
    }

    @Nullable
    public Map<String, NameDescriptorPair> getMappings(@NotNull String version) {
        return this.mappings.get(version);
    }

    @Nullable
    public NameDescriptorPair getName(@NotNull String version, String ... namespaces) {
        Map<String, NameDescriptorPair> versionMappings = this.getMappings(version);
        if (versionMappings == null) {
            return null;
        }
        for (String namespace : namespaces) {
            NameDescriptorPair namePair = versionMappings.get(namespace);
            if (namePair == null) continue;
            return namePair;
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public MethodMapping chain(@NotNull MethodMapping other) {
        if (this.parent != other.parent) {
            throw new IllegalArgumentException("Could not chain method mappings, disassociated mapping parent");
        }
        HashMap<String, Map<String, NameDescriptorPair>> newMappings = new HashMap<String, Map<String, NameDescriptorPair>>(other.mappings.size());
        for (Map.Entry<String, Map<String, NameDescriptorPair>> entry : other.mappings.entrySet()) {
            HashMap<String, NameDescriptorPair> newMappings1 = new HashMap<String, NameDescriptorPair>(entry.getValue().size());
            newMappings1.putAll(entry.getValue());
            newMappings.put(entry.getKey(), newMappings1);
        }
        for (Map.Entry<String, Map<String, NameDescriptorPair>> entry : this.mappings.entrySet()) {
            newMappings.computeIfAbsent(entry.getKey(), k -> new HashMap(((Map)entry.getValue()).size())).putAll(entry.getValue());
        }
        return new MethodMapping(this.parent, this.name, -1, newMappings);
    }

    @Nullable
    public Method getMethod(@NotNull ClassLoader loader, @NotNull String version, String ... namespaces) {
        Class<?> clazz = this.parent.getClass(loader, version, namespaces);
        if (clazz == null) {
            return null;
        }
        NameDescriptorPair namePair = this.getName(version, namespaces);
        if (namePair == null) {
            return null;
        }
        String[] types = namePair.getParameters();
        Class[] paramClasses = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> paramClass = MethodMapping.parseClass(loader, types[i]);
            if (paramClass == null) {
                return null;
            }
            paramClasses[i] = paramClass;
        }
        try {
            return clazz.getMethod(namePair.getName(), paramClasses);
        }
        catch (NoSuchMethodException ignored) {
            while (true) {
                try {
                    Method method = clazz.getDeclaredMethod(namePair.getName(), paramClasses);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) continue;
                    return null;
                }
                break;
            }
        }
    }

    @Nullable
    public Method getMethod(@NotNull String version, String ... namespaces) {
        return this.getMethod(Thread.currentThread().getContextClassLoader(), version, namespaces);
    }

    @Nullable
    public Method getMethod(@NotNull MapperPlatform platform) {
        return this.getMethod(platform.getClassLoader(), platform.getVersion(), platform.getMappingNamespaces());
    }

    @Nullable
    public Method getMethod() {
        return this.getMethod(MapperPlatforms.getCurrentPlatform());
    }

    @Nullable
    public MethodHandle getMethodHandle(@NotNull ClassLoader loader, @NotNull String version, String ... namespaces) {
        Method method = this.getMethod(loader, version, namespaces);
        if (method == null) {
            return null;
        }
        try {
            return MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.sneakyThrow(e);
            return null;
        }
    }

    @Nullable
    public MethodHandle getMethodHandle(@NotNull String version, String ... namespaces) {
        return this.getMethodHandle(Thread.currentThread().getContextClassLoader(), version, namespaces);
    }

    @Nullable
    public MethodHandle getMethodHandle(@NotNull MapperPlatform platform) {
        return this.getMethodHandle(platform.getClassLoader(), platform.getVersion(), platform.getMappingNamespaces());
    }

    @Nullable
    public MethodHandle getMethodHandle() {
        return this.getMethodHandle(MapperPlatforms.getCurrentPlatform());
    }

    @ApiStatus.Internal
    @Contract(value="_, _, _, _ -> this")
    @NotNull
    public MethodMapping put(@NotNull String namespace, @NotNull String[] versions, @NotNull String name, String ... types) {
        for (String version : versions) {
            this.mappings.computeIfAbsent(version, k -> new HashMap()).put(namespace, new NameDescriptorPair(name, types));
        }
        return this;
    }

    @NotNull
    public ClassMapping getParent() {
        return this.parent;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public Map<String, Map<String, NameDescriptorPair>> getMappings() {
        return this.mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodMapping that = (MethodMapping)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.parent != that.parent) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.mappings.equals(that.mappings);
    }

    public int hashCode() {
        int result = System.identityHashCode(this.parent);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    public String toString() {
        return "MethodMapping{name='" + this.name + '\'' + ", index=" + this.index + ", mappings=" + this.mappings + '}';
    }
}

