/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.vivecraft.ViveMain;
import org.vivecraft.util.Utils;

public class RecipeManager {
    private final List<ShapedRecipe> climbeyRecipes = new ArrayList<ShapedRecipe>();

    public RecipeManager() {
        this.createClawsRecipe();
        this.createBootsRecipe();
    }

    private void createClawsRecipe() {
        ItemStack claws = new ItemStack(Material.SHEARS);
        if (!ViveMain.API.setItemStackUnbreakable(claws, true)) {
            ViveMain.LOGGER.info("Error creating boots recipe, not added");
            return;
        }
        claws = ViveMain.NMS.setItemStackName(claws, "vivecraft.item.climbclaws", "Climb Claws");
        ShapedRecipe clawsRecipe = ViveMain.API.createRecipe(claws, "climb_claws");
        clawsRecipe.shape(new String[]{"E E", "S S"});
        clawsRecipe.setIngredient('E', Material.SPIDER_EYE);
        clawsRecipe.setIngredient('S', Material.SHEARS);
        this.climbeyRecipes.add(clawsRecipe);
    }

    private void createBootsRecipe() {
        ItemStack boots = new ItemStack(Material.LEATHER_BOOTS);
        if (!ViveMain.API.setItemStackUnbreakable(boots, true)) {
            ViveMain.LOGGER.info("Error creating boots recipe, not added");
            return;
        }
        boots = ViveMain.NMS.setItemStackName(boots, "vivecraft.item.jumpboots", "Jump Boots");
        ItemMeta bootsMeta = boots.getItemMeta();
        ((LeatherArmorMeta)bootsMeta).setColor(Color.fromRGB((int)9233775));
        boots.setItemMeta(bootsMeta);
        ShapedRecipe bootsRecipe = ViveMain.API.createRecipe(boots, "jump_boots");
        bootsRecipe.shape(new String[]{"B", "S"});
        bootsRecipe.setIngredient('B', Material.LEATHER_BOOTS);
        bootsRecipe.setIngredient('S', Material.SLIME_BLOCK);
        this.climbeyRecipes.add(bootsRecipe);
    }

    public void updateRecipes() {
        if (((Boolean)ViveMain.CONFIG.viveCrafting.get()).booleanValue() && ((Boolean)ViveMain.CONFIG.climbeyEnabled.get()).booleanValue()) {
            this.addRecipes(this.climbeyRecipes);
        } else {
            this.removeRecipes(this.climbeyRecipes);
        }
    }

    public void addRecipes(List<ShapedRecipe> toAdd) {
        for (ShapedRecipe recipe : toAdd) {
            if (this.hasRecipe(recipe)) continue;
            Bukkit.addRecipe((Recipe)recipe);
        }
    }

    public void removeRecipes(List<ShapedRecipe> toRemove) {
        Iterator recipes = Bukkit.recipeIterator();
        while (recipes.hasNext()) {
            Recipe recipe = (Recipe)recipes.next();
            for (ShapedRecipe customRecipe : toRemove) {
                if (!this.recipeEquals(customRecipe, recipe)) continue;
                recipes.remove();
            }
        }
    }

    private boolean hasRecipe(ShapedRecipe recipe) {
        Iterator recipes = Bukkit.recipeIterator();
        while (recipes.hasNext()) {
            if (!this.recipeEquals(recipe, (Recipe)recipes.next())) continue;
            return true;
        }
        return false;
    }

    private boolean recipeEquals(ShapedRecipe customRecipe, Recipe other) {
        if (!(other instanceof ShapedRecipe) || other.getResult().getType() != customRecipe.getResult().getType()) {
            return false;
        }
        ShapedRecipe otherRecipe = (ShapedRecipe)other;
        if (otherRecipe.getShape().length != customRecipe.getShape().length) {
            return false;
        }
        Map customItems = customRecipe.getIngredientMap();
        Map otherItems = otherRecipe.getIngredientMap();
        if (Utils.containsAll(customItems.values(), otherItems.values())) {
            String customShape = String.join((CharSequence)"", customRecipe.getShape());
            String otherShape = String.join((CharSequence)"", otherRecipe.getShape());
            for (int i = 0; i < customShape.length(); ++i) {
                ItemStack otherItem;
                ItemStack customItem = (ItemStack)customItems.get(Character.valueOf(customShape.charAt(i)));
                if (Objects.equals(customItem, otherItem = (ItemStack)otherItems.get(Character.valueOf(otherShape.charAt(i))))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

