/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.vivecraft.PermissionManager;
import org.vivecraft.RecipeManager;
import org.vivecraft.VivePlayer;
import org.vivecraft.commands.ConfigCommandExecutor;
import org.vivecraft.commands.ConfigCommandTabCompleter;
import org.vivecraft.compat.ApiHelper;
import org.vivecraft.compat.MCMods;
import org.vivecraft.compat.McHelper;
import org.vivecraft.compat.NMSHelper;
import org.vivecraft.compat.Platform;
import org.vivecraft.compat.SpigotReflector;
import org.vivecraft.compat.Task;
import org.vivecraft.config.Config;
import org.vivecraft.debug.Debug;
import org.vivecraft.events.DamageEvents;
import org.vivecraft.events.EntityEvents;
import org.vivecraft.events.PlayerEvents;
import org.vivecraft.events.ProjectileEvents;
import org.vivecraft.linker.Helpers;
import org.vivecraft.network.NetworkHandler;
import org.vivecraft.util.JsonUtils;
import org.vivecraft.util.MCVersion;
import org.vivecraft.util.UpdateChecker;

public class ViveMain
extends JavaPlugin {
    public static ViveMain INSTANCE;
    public static Logger LOGGER;
    public static Config CONFIG;
    public static Map<UUID, VivePlayer> VIVE_PLAYERS;
    public static ApiHelper API;
    public static McHelper MC;
    public static NMSHelper NMS;
    public static MCMods MC_MODS;
    public static String VERSION;
    public static Map<String, String> TRANSLATIONS;
    private Task dataTask;
    private Task particleTask;
    private RecipeManager recipeManager;

    public void onEnable() {
        String configCommandString;
        PluginCommand configCommand;
        INSTANCE = this;
        LOGGER = this.getLogger();
        VERSION = this.getDescription().getName() + " " + this.getDescription().getVersion();
        TRANSLATIONS = JsonUtils.readJsonMap(this.getResource("lang/en_us.json"));
        TRANSLATIONS.putAll(JsonUtils.readJsonMap(this.getResource("lang/spigot_en_us.json")));
        API = Helpers.getApi();
        MC = Helpers.getMc();
        NMS = Helpers.getNMS();
        MC_MODS = new MCMods();
        CONFIG = new Config((Plugin)this);
        if (((Boolean)ViveMain.CONFIG.checkForUpdates.get()).booleanValue()) {
            UpdateChecker.scheduleUpdateCheck(LOGGER::info);
        }
        if (!PermissionManager.checkForVault() && ((Boolean)ViveMain.CONFIG.permissionsGroupsEnabled.get()).booleanValue()) {
            LOGGER.warning("To use the permission groups feature, 'Vault' needs to be installed");
        }
        if ((configCommand = this.getCommand(configCommandString = "vivecraft-server-config")) != null) {
            configCommand.setExecutor((CommandExecutor)new ConfigCommandExecutor());
            configCommand.setTabCompleter((TabCompleter)new ConfigCommandTabCompleter());
        } else {
            LOGGER.severe("Command '" + configCommandString + "' is missing and couldn't be set up!");
        }
        NetworkHandler handler = new NetworkHandler(this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "vivecraft:data", (PluginMessageListener)handler);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "vivecraft:data");
        if (MCVersion.getCurrent().major < 13) {
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "Vivecraft", (PluginMessageListener)handler);
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "Vivecraft");
        }
        this.registerEvents(this.getServer().getPluginManager());
        this.toggleParticleTask((Boolean)ViveMain.CONFIG.debugParticlesEnabled.get());
        this.toggleDataTask((Boolean)ViveMain.CONFIG.sendData.get());
        if (((Boolean)ViveMain.CONFIG.spigotSettingsEnabled.get()).booleanValue()) {
            SpigotReflector.setMovedTooQuickly((Double)ViveMain.CONFIG.spigotSettingsMovedTooQuickly.get());
            SpigotReflector.setMovedWrongly((Double)ViveMain.CONFIG.spigotSettingsMovedWronglyThreshold.get());
        }
        this.modifyEntities();
        this.recipeManager = new RecipeManager();
        this.updateRecipes();
    }

    private void modifyEntities() {
        List wrl = this.getServer().getWorlds();
        for (World world : wrl) {
            for (Entity e : world.getLivingEntities()) {
                NMS.modifyEntity(e);
            }
        }
    }

    private void registerEvents(PluginManager manager) {
        manager.registerEvents((Listener)new ProjectileEvents(), (Plugin)this);
        manager.registerEvents((Listener)new PlayerEvents(), (Plugin)this);
        manager.registerEvents((Listener)new DamageEvents(), (Plugin)this);
        manager.registerEvents((Listener)new EntityEvents(), (Plugin)this);
    }

    public void updateRecipes() {
        this.recipeManager.updateRecipes();
    }

    public void onDisable() {
        if (this.dataTask != null) {
            this.dataTask.cancel();
            this.dataTask = null;
        }
        if (this.particleTask != null) {
            this.particleTask.cancel();
            this.particleTask = null;
        }
    }

    private static void sendViveData() {
        for (VivePlayer vivePlayer : VIVE_PLAYERS.values()) {
            if (!vivePlayer.isVR() || vivePlayer.vrPlayerState() == null) continue;
            NetworkHandler.sendVrPlayerStateToClients(vivePlayer);
        }
    }

    public static boolean isVivePlayer(Entity entity) {
        return entity instanceof Player && VIVE_PLAYERS.containsKey(entity.getUniqueId());
    }

    public static boolean isVRPlayer(Entity entity) {
        return ViveMain.isVivePlayer(entity) && ViveMain.getVivePlayer(entity).isVR();
    }

    public static boolean isVRPlayer(UUID uuid) {
        return VIVE_PLAYERS.containsKey(uuid) && VIVE_PLAYERS.get(uuid).isVR();
    }

    public static VivePlayer getVivePlayer(Entity entity) {
        return VIVE_PLAYERS.get(entity.getUniqueId());
    }

    public static VivePlayer getVivePlayer(UUID uuid) {
        return VIVE_PLAYERS.get(uuid);
    }

    public void toggleParticleTask(boolean enabled) {
        if (enabled && this.particleTask == null) {
            this.particleTask = Platform.getInstance().getScheduler().runGlobalRepeating(Debug::debugParticles, 20L, 1L);
        } else if (!enabled && this.particleTask != null) {
            this.particleTask.cancel();
            this.particleTask = null;
        }
    }

    public void toggleDataTask(boolean enabled) {
        Debug.log("setting data task to %s", enabled);
        if (enabled && this.dataTask == null) {
            this.dataTask = Platform.getInstance().getScheduler().runGlobalRepeating(ViveMain::sendViveData, 20L, 1L);
        } else if (!enabled && this.dataTask != null) {
            this.dataTask.cancel();
            this.dataTask = null;
        }
    }

    public static String translate(String key, Object ... args) {
        if (args != null && args.length > 0) {
            Object[] s = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                s[i] = String.valueOf(args[i]);
            }
            return String.format(TRANSLATIONS.get(key), s);
        }
        return String.format(TRANSLATIONS.get(key), new Object[0]);
    }

    static {
        VIVE_PLAYERS = new HashMap<UUID, VivePlayer>();
    }
}

