/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.api.data;

import org.vivecraft.api.data.FBTMode;

public enum VRBodyPart {
    MAIN_HAND,
    OFF_HAND,
    RIGHT_FOOT,
    LEFT_FOOT,
    WAIST,
    RIGHT_KNEE,
    LEFT_KNEE,
    RIGHT_ELBOW,
    LEFT_ELBOW,
    HEAD;


    public VRBodyPart opposite() {
        switch (this.ordinal()) {
            case 0: {
                return OFF_HAND;
            }
            case 1: {
                return MAIN_HAND;
            }
            case 2: {
                return LEFT_FOOT;
            }
            case 3: {
                return RIGHT_FOOT;
            }
            case 5: {
                return LEFT_KNEE;
            }
            case 6: {
                return RIGHT_KNEE;
            }
            case 7: {
                return LEFT_ELBOW;
            }
            case 8: {
                return RIGHT_ELBOW;
            }
        }
        return this;
    }

    public boolean availableInMode(FBTMode fbtMode) {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 9: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: {
                return fbtMode != FBTMode.ARMS_ONLY;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return fbtMode == FBTMode.WITH_JOINTS;
            }
        }
        return false;
    }

    public boolean isFoot() {
        return this == RIGHT_FOOT || this == LEFT_FOOT;
    }

    public boolean isHand() {
        return this == MAIN_HAND || this == OFF_HAND;
    }
}

