/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.api_impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.api.VRAPI;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import org.vivecraft.api_impl.data.VRPoseHistoryImpl;
import org.vivecraft.network.NetworkHandler;

public class VRAPIImpl
implements VRAPI {
    public static final VRAPIImpl INSTANCE = new VRAPIImpl();
    public static final int MAX_HISTORY_TICKS = 200;
    private final Map<UUID, VRPoseHistoryImpl> serverPoseHistories = new HashMap<UUID, VRPoseHistoryImpl>();

    public void clearPoseHistory(UUID player) {
        this.serverPoseHistories.remove(player);
    }

    public void addPoseToHistory(UUID player, VRPose pose, Vector playerPos) {
        VRPoseHistoryImpl poseHistory = this.serverPoseHistories.get(player);
        if (poseHistory == null) {
            poseHistory = new VRPoseHistoryImpl();
            this.serverPoseHistories.put(player, poseHistory);
        }
        poseHistory.addPose(pose, playerPos);
    }

    public void clearAllPoseHistories() {
        this.serverPoseHistories.clear();
    }

    @Override
    public boolean isVRPlayer(Player player) {
        VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
        return vivePlayer != null && vivePlayer.isVR();
    }

    @Override
    @Nullable
    public VRPose getVRPose(Player player) {
        if (!this.isVRPlayer(player)) {
            return null;
        }
        return ViveMain.getVivePlayer((Entity)player).asVRPose();
    }

    @Override
    @Nullable
    public VRPoseHistory getHistoricalVRPoses(Player player) {
        if (this.isVRPlayer(player)) {
            return this.serverPoseHistories.get(player.getUniqueId());
        }
        return null;
    }

    @Override
    public void sendHapticPulse(Player player, VRBodyPart bodyPart, float duration, float frequency, float amplitude, float delay) {
        if (INSTANCE.isVRPlayer(player)) {
            NetworkHandler.sendHapticToClient(player, bodyPart, duration, frequency, amplitude, delay);
        }
    }
}

