/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.api_impl.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import org.vivecraft.api_impl.data.VRPoseImpl;

public class VRPoseHistoryImpl
implements VRPoseHistory {
    private final LinkedList<PoseData> dataQueue = new LinkedList();

    public void addPose(VRPose pose, Vector playerPos) {
        this.dataQueue.addFirst(new PoseData(pose, playerPos));
        if (this.dataQueue.size() > 201) {
            this.dataQueue.removeLast();
        }
    }

    public void clear() {
        this.dataQueue.clear();
    }

    @Override
    public int ticksOfHistory() {
        return this.dataQueue.size() - 1;
    }

    @Override
    public List<VRPose> getAllHistoricalData() {
        return Collections.unmodifiableList(this.dataQueue.stream().map(data -> data.pose).collect(Collectors.toList()));
    }

    @Override
    public VRPose getHistoricalData(int ticksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        this.checkTicksBack(ticksBack);
        if (this.dataQueue.size() <= ticksBack) {
            return null;
        }
        return this.dataQueue.get(ticksBack).getPose(playerPositionRelative);
    }

    @Override
    public Vector netMovement(VRBodyPart bodyPart, int maxTicksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return new Vector();
        }
        Vector current = this.dataQueue.getFirst().getPos(bodyPart, playerPositionRelative);
        if (current == null) {
            return null;
        }
        Vector old = this.dataQueue.get(maxTicksBack).getPos(bodyPart, playerPositionRelative);
        if (old == null) {
            return null;
        }
        return current.subtract(old);
    }

    @Override
    public Vector averageVelocity(VRBodyPart bodyPart, int maxTicksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return new Vector();
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Vector> diffs = new ArrayList<Vector>(maxTicksBack);
        for (int i = 0; i < maxTicksBack; ++i) {
            Vector newer = this.dataQueue.get(i).getPos(bodyPart, playerPositionRelative);
            Vector older = this.dataQueue.get(i + 1).getPos(bodyPart, playerPositionRelative);
            if (newer == null || older == null) break;
            diffs.add(newer.subtract(older));
        }
        if (diffs.isEmpty()) {
            return this.dataQueue.getFirst().pose.getBodyPartData(bodyPart) != null ? new Vector() : null;
        }
        return new Vector(diffs.stream().mapToDouble(Vector::getX).average().orElse(0.0), diffs.stream().mapToDouble(Vector::getY).average().orElse(0.0), diffs.stream().mapToDouble(Vector::getZ).average().orElse(0.0));
    }

    @Override
    public double averageSpeed(VRBodyPart bodyPart, int maxTicksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return 0.0;
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Double> speeds = new ArrayList<Double>(maxTicksBack);
        for (int i = 0; i < maxTicksBack; ++i) {
            Vector newer = this.dataQueue.get(i).getPos(bodyPart, playerPositionRelative);
            Vector older = this.dataQueue.get(i + 1).getPos(bodyPart, playerPositionRelative);
            if (newer == null || older == null) break;
            speeds.add(newer.distance(older));
        }
        return speeds.stream().mapToDouble(Double::valueOf).average().orElse(0.0);
    }

    @Override
    public Vector averagePosition(VRBodyPart bodyPart, int maxTicksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        PoseData poseData;
        Vector pos;
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.isEmpty()) {
            return null;
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Vector> positions = new ArrayList<Vector>(maxTicksBack);
        int i = 0;
        Iterator iterator = this.dataQueue.iterator();
        while (iterator.hasNext() && (pos = (poseData = (PoseData)iterator.next()).getPos(bodyPart, playerPositionRelative)) != null) {
            positions.add(pos);
            if (++i < maxTicksBack) continue;
            break;
        }
        if (positions.isEmpty()) {
            return null;
        }
        return new Vector(positions.stream().mapToDouble(Vector::getX).average().orElse(0.0), positions.stream().mapToDouble(Vector::getY).average().orElse(0.0), positions.stream().mapToDouble(Vector::getZ).average().orElse(0.0));
    }

    private void checkTicksBack(int ticksBack) {
        if (ticksBack < 0 || ticksBack > 200) {
            throw new IllegalArgumentException("Value must be between 0 and 200.");
        }
    }

    private void checkPartNonNull(VRBodyPart bodyPart) {
        if (bodyPart == null) {
            throw new IllegalArgumentException("Cannot get data for a null body part!");
        }
    }

    private int getNumTicksBack(int maxTicksBack) {
        if (this.dataQueue.size() <= maxTicksBack) {
            return this.dataQueue.size() - 1;
        }
        return maxTicksBack;
    }

    private static class PoseData {
        protected final VRPose pose;
        protected final Vector playerPosition;

        private PoseData(VRPose pose, Vector playerPosition) {
            this.pose = pose;
            this.playerPosition = playerPosition;
        }

        @Nullable
        public Vector getPos(VRBodyPart vrBodyPart, boolean playerPositionRelative) {
            VRBodyPartData vrBodyPartData = this.pose.getBodyPartData(vrBodyPart);
            if (vrBodyPartData == null) {
                return null;
            }
            if (playerPositionRelative) {
                return vrBodyPartData.getPos().subtract(this.playerPosition);
            }
            return vrBodyPartData.getPos();
        }

        public VRPose getPose(boolean playerPositionRelative) {
            if (playerPositionRelative) {
                return ((VRPoseImpl)this.pose).relativeToPosition(this.playerPosition);
            }
            return this.pose;
        }
    }
}

