/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.vivecraft.ViveMain;
import org.vivecraft.config.ConfigBuilder;
import org.vivecraft.config.enums.ClimbeyBlockmode;
import org.vivecraft.config.enums.HeadshotIndicator;
import org.vivecraft.config.enums.UpdateType;
import org.vivecraft.network.NetworkHandler;
import org.vivecraft.network.PacketUtils;
import org.vivecraft.network.packet.s2c.AttackWhileBlockingPayloadS2C;
import org.vivecraft.network.packet.s2c.CrawlPayloadS2C;
import org.vivecraft.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.network.packet.s2c.TeleportPayloadS2C;
import org.vivecraft.util.MCVersion;
import org.vivecraft.util.UpdateChecker;

public class Config {
    public final ConfigBuilder.BooleanValue debug;
    public final ConfigBuilder.BooleanValue debugParticlesEnabled;
    public final ConfigBuilder.BooleanValue debugParticlesOpOnly;
    public final ConfigBuilder.BooleanValue debugParticlesVrDevice;
    public final ConfigBuilder.BooleanValue debugParticlesVrHead;
    public final ConfigBuilder.BooleanValue debugParticlesHeadHitbox;
    public final ConfigBuilder.BooleanValue checkForUpdates;
    public final ConfigBuilder.EnumValue<UpdateType> updateType;
    public final ConfigBuilder.BooleanValue vrOnly;
    public final ConfigBuilder.BooleanValue viveOnly;
    public final ConfigBuilder.BooleanValue allowOp;
    public final ConfigBuilder.IntValue messageKickDelay;
    public final ConfigBuilder.BooleanValue vrFun;
    public final ConfigBuilder.BooleanValue viveCrafting;
    public final ConfigBuilder.BooleanValue requestData;
    public final ConfigBuilder.BooleanValue sendData;
    public final ConfigBuilder.BooleanValue sendDataToOwner;
    public final ConfigBuilder.BooleanValue kickPlayersOnSettingUpdate;
    public final ConfigBuilder.BooleanValue spigotSettingsEnabled;
    public final ConfigBuilder.DoubleValue spigotSettingsMovedTooQuickly;
    public final ConfigBuilder.DoubleValue spigotSettingsMovedWronglyThreshold;
    public final ConfigBuilder.BooleanValue permissionsGroupsEnabled;
    public final ConfigBuilder.StringValue permissionsNonVRGroup;
    public final ConfigBuilder.StringValue permissionsVRGroup;
    public final ConfigBuilder.StringValue permissionsClimbPermission;
    public final ConfigBuilder.BooleanValue messagesEnabled;
    public final ConfigBuilder.StringValue messagesWelcomeVr;
    public final ConfigBuilder.StringValue messagesWelcomeNonvr;
    public final ConfigBuilder.StringValue messagesWelcomeSeated;
    public final ConfigBuilder.StringValue messagesWelcomeVanilla;
    public final ConfigBuilder.StringValue messagesDeathVr;
    public final ConfigBuilder.StringValue messagesDeathNonvr;
    public final ConfigBuilder.StringValue messagesDeathSeated;
    public final ConfigBuilder.StringValue messagesDeathVanilla;
    public final ConfigBuilder.StringValue messagesDeathByMobVr;
    public final ConfigBuilder.StringValue messagesDeathByMobNonvr;
    public final ConfigBuilder.StringValue messagesDeathByMobSeated;
    public final ConfigBuilder.StringValue messagesDeathByMobVanilla;
    public final ConfigBuilder.StringValue messagesLeaveMessage;
    public final ConfigBuilder.StringValue messagesKickViveOnly;
    public final ConfigBuilder.StringValue messagesKickVrOnly;
    public final ConfigBuilder.BooleanValue dualWielding;
    public final ConfigBuilder.DoubleValue bootsArmorDamage;
    public final ConfigBuilder.DoubleValue creeperSwellDistance;
    public final ConfigBuilder.DoubleValue mobAttackRangeAdjustment;
    public final ConfigBuilder.DoubleValue projectileInaccuracyMultiplier;
    public final ConfigBuilder.BooleanValue allowFasterBlockBreaking;
    public final ConfigBuilder.BooleanValue allowRoomscaleShieldBlocking;
    public final ConfigBuilder.BooleanValue allowAttacksWhileBlocking;
    public final ConfigBuilder.DoubleValue bowStandingMultiplier;
    public final ConfigBuilder.DoubleValue bowSeatedMultiplier;
    public final ConfigBuilder.DoubleValue bowStandingHeadshotMultiplier;
    public final ConfigBuilder.DoubleValue bowSeatedHeadshotMultiplier;
    public final ConfigBuilder.DoubleValue bowVanillaHeadshotMultiplier;
    public final ConfigBuilder.EnumValue<HeadshotIndicator> bowHeadshotIndicator;
    public final ConfigBuilder.BooleanValue pvpVrVsVr;
    public final ConfigBuilder.BooleanValue pvpSeatedvrVsSeatedvr;
    public final ConfigBuilder.BooleanValue pvpVrVsNonvr;
    public final ConfigBuilder.BooleanValue pvpSeatedvrVsNonvr;
    public final ConfigBuilder.BooleanValue pvpVrVsSeatedvr;
    public final ConfigBuilder.BooleanValue pvpNotifyBlockedDamage;
    public final ConfigBuilder.BooleanValue climbeyEnabled;
    public final ConfigBuilder.EnumValue<ClimbeyBlockmode> climbeyBlockmode;
    public final ConfigBuilder.StringListValue climbeyBlocklist;
    public final ConfigBuilder.BooleanValue crawlingEnabled;
    public final ConfigBuilder.BooleanValue teleportEnabled;
    public final ConfigBuilder.BooleanValue teleportLimitedSurvival;
    public final ConfigBuilder.IntValue teleportUpLimit;
    public final ConfigBuilder.IntValue teleportDownLimit;
    public final ConfigBuilder.IntValue teleportHorizontalLimit;
    public final ConfigBuilder.BooleanValue worldscaleLimited;
    public final ConfigBuilder.DoubleValue worldscaleMax;
    public final ConfigBuilder.DoubleValue worldscaleMin;
    public final ConfigBuilder.BooleanValue forceThirdPersonItems;
    public final ConfigBuilder.BooleanValue forceThirdPersonItemsCustom;
    public final ConfigBuilder.BooleanValue vrSwitchingEnabled;
    private final ConfigBuilder builder;
    private final Plugin plugin;
    private final boolean inMemory;

    public Config(Plugin plugin) {
        this(plugin, false);
    }

    public Config(Plugin plugin, boolean inMemory) {
        MCVersion mc;
        this.plugin = plugin;
        this.inMemory = inMemory;
        try {
            mc = MCVersion.getCurrent();
        }
        catch (Exception e) {
            mc = MCVersion.MAX;
        }
        this.builder = new ConfigBuilder(plugin.getConfig());
        this.builder.push("general");
        this.checkForUpdates = (ConfigBuilder.BooleanValue)this.builder.push("checkForUpdate").define(true).setOnUpdate((oV, nV, notifier) -> {
            if (nV.booleanValue()) {
                UpdateChecker.scheduleUpdateCheck(notifier);
            }
        });
        this.updateType = (ConfigBuilder.EnumValue)this.builder.push("checkForUpdateType").defineEnum(UpdateType.RELEASE, UpdateType.class).setOnUpdate((oV, nV, notifier) -> {
            if (((Boolean)this.checkForUpdates.get()).booleanValue() && oV != nV) {
                UpdateChecker.scheduleUpdateCheck(notifier);
            }
        });
        this.vrOnly = (ConfigBuilder.BooleanValue)this.builder.push("vr_only").define(false).setOnUpdate(nV -> NetworkHandler.updateViveVROnly());
        this.viveOnly = (ConfigBuilder.BooleanValue)this.builder.push("vive_only").define(false).setOnUpdate(nV -> NetworkHandler.updateViveVROnly());
        this.allowOp = (ConfigBuilder.BooleanValue)this.builder.push("allow_op").define(true).setOnUpdate(nV -> NetworkHandler.updateViveVROnly());
        this.messageKickDelay = this.builder.push("messageAndKickDelay").defineInRange(200, 100, 1000);
        this.vrFun = this.builder.push("vrFun").define(true);
        this.viveCrafting = (ConfigBuilder.BooleanValue)this.builder.push("viveCrafting").define(true).setOnUpdate(nV -> ViveMain.INSTANCE.updateRecipes());
        this.requestData = (ConfigBuilder.BooleanValue)this.builder.push("requestData").define(true).setNeedsReload(true);
        this.sendData = (ConfigBuilder.BooleanValue)this.builder.push("sendData").define(true).setOnUpdate(nV -> ViveMain.INSTANCE.toggleDataTask((boolean)nV));
        this.sendDataToOwner = this.builder.push("sendDataToOwner").define(false);
        this.kickPlayersOnSettingUpdate = this.builder.push("kickPlayersOnSettingUpdate").define(false);
        this.builder.pop();
        this.builder.push("setSpigotSettings");
        this.spigotSettingsEnabled = (ConfigBuilder.BooleanValue)this.builder.push("enabled").define(true).setNeedsReload(true);
        this.spigotSettingsMovedWronglyThreshold = (ConfigBuilder.DoubleValue)this.builder.push("movedWronglyThreshold").defineInRange(15.0, 0.0, 10000.0).setNeedsReload(true);
        this.spigotSettingsMovedTooQuickly = (ConfigBuilder.DoubleValue)this.builder.push("movedTooQuickly").defineInRange(64.0, 0.0, 10000.0).setNeedsReload(true);
        this.builder.pop();
        this.builder.push("permissions");
        this.permissionsGroupsEnabled = this.builder.push("groupsEnabled").define(true);
        this.permissionsNonVRGroup = this.builder.push("NonVRgroup").define("vive.non-vivegroup");
        this.permissionsVRGroup = this.builder.push("VRgroup").define("vive.vivegroup");
        this.permissionsClimbPermission = (ConfigBuilder.StringValue)this.builder.push("climbperm").define("vive.climbanywhere").setPacketFunction((v, p) -> PacketUtils.getClimbeyServerPayload(p));
        this.builder.pop();
        this.builder.push("messages");
        this.messagesEnabled = this.builder.push("enabled").define(false);
        this.messagesWelcomeVr = this.builder.push("welcomeVR").define("&player has joined with standing VR!");
        this.messagesWelcomeNonvr = this.builder.push("welcomeNonVR").define("&player has joined with Non-VR companion!");
        this.messagesWelcomeSeated = this.builder.push("welcomeSeated").define("&player has joined with seated VR!");
        this.messagesWelcomeVanilla = this.builder.push("welcomeVanilla").define("&player has joined as a Muggle!");
        this.messagesLeaveMessage = this.builder.push("leaveMessage").define("&player has disconnected from the server!");
        this.messagesDeathVr = this.builder.push("deathVR").define("&player died in standing VR!");
        this.messagesDeathNonvr = this.builder.push("deathNonVR").define("&player died in Non-VR companion!");
        this.messagesDeathSeated = this.builder.push("deathSeated").define("&player died in seated VR!");
        this.messagesDeathVanilla = this.builder.push("deathVanilla").define("&player died as a Muggle!");
        this.messagesDeathByMobVr = this.builder.push("deathByMobVR").define("&player was slain by &cause in standing VR!");
        this.messagesDeathByMobNonvr = this.builder.push("deathByMobNonVR").define("&player was slain by &cause in Non-VR companion!");
        this.messagesDeathByMobSeated = this.builder.push("deathByMobSeated").define("&player was slain by &cause in seated VR!");
        this.messagesDeathByMobVanilla = this.builder.push("deathByMobVanilla").define("&player was slain by &cause as a Muggle!");
        this.messagesKickViveOnly = this.builder.push("KickViveOnly").define("This server is configured for Vivecraft players only.");
        this.messagesKickVrOnly = this.builder.push("KickVROnly").define("This server is configured for VR players only.");
        this.builder.pop();
        this.builder.push("vrChanges");
        this.creeperSwellDistance = this.builder.push("creeperSwellDistance").defineInRange(1.75, 0.1, 10.0);
        this.mobAttackRangeAdjustment = this.builder.push("mobAttackRangeAdjustment").defineInRange(-0.4, -0.7, 0.0);
        this.dualWielding = (ConfigBuilder.BooleanValue)this.builder.push("dualWielding").define(true).setPacketFunction((v, p) -> new DualWieldingPayloadS2C((boolean)v));
        this.bootsArmorDamage = this.builder.push("bootsArmorDamage").defineInRange(0.0, 0.0, 5.0);
        this.projectileInaccuracyMultiplier = this.builder.push("projectileInaccuracyMultiplier").defineInRange(1.0, 0.0, 1.0);
        this.allowFasterBlockBreaking = this.builder.push("allowFasterBlockBreaking").define(true);
        this.allowRoomscaleShieldBlocking = this.builder.push("allowRoomscaleShieldBlocking").define(true);
        this.allowAttacksWhileBlocking = (ConfigBuilder.BooleanValue)this.builder.push("allowAttacksWhileBlocking").define(true).setPacketFunction((v, p) -> new AttackWhileBlockingPayloadS2C((boolean)v));
        this.builder.push("bow");
        this.bowStandingMultiplier = (ConfigBuilder.DoubleValue)this.builder.push("standingMultiplier").defineInRange(1.5, 1.0, 10.0).setClientDefault(2.0);
        this.bowSeatedMultiplier = this.builder.push("seatedMultiplier").defineInRange(1.0, 1.0, 10.0);
        this.bowStandingHeadshotMultiplier = (ConfigBuilder.DoubleValue)this.builder.push("standingHeadshotMultiplier").defineInRange(2.0, 1.0, 10.0).setClientDefault(3.0);
        this.bowSeatedHeadshotMultiplier = (ConfigBuilder.DoubleValue)this.builder.push("seatedHeadshotMultiplier").defineInRange(1.5, 1.0, 10.0).setClientDefault(2.0);
        this.bowVanillaHeadshotMultiplier = this.builder.push("vanillaHeadshotMultiplier").defineInRange(1.0, 1.0, 10.0);
        this.bowHeadshotIndicator = this.builder.push("headshotIndicator").defineEnum(HeadshotIndicator.BOTH, HeadshotIndicator.class);
        this.builder.pop();
        this.builder.pop();
        this.builder.push("pvp");
        this.pvpNotifyBlockedDamage = this.builder.push("notifyBlockedDamage").define(false);
        this.pvpVrVsVr = this.builder.push("VRvsVR").define(true);
        this.pvpSeatedvrVsSeatedvr = this.builder.push("SEATEDVRvsSEATEDVR").define(true);
        this.pvpVrVsNonvr = this.builder.push("VRvsNONVR").define(true);
        this.pvpSeatedvrVsNonvr = this.builder.push("SEATEDVRvsNONVR").define(true);
        this.pvpVrVsSeatedvr = this.builder.push("VRvsSEATEDVR").define(true);
        this.builder.pop();
        this.builder.push("climbey");
        this.climbeyEnabled = (ConfigBuilder.BooleanValue)((ConfigBuilder.ConfigValue)this.builder.push("enabled").define(false).setPacketFunction((v, p) -> PacketUtils.getClimbeyServerPayload(p))).setOnUpdate(nV -> ViveMain.INSTANCE.updateRecipes());
        this.climbeyBlockmode = (ConfigBuilder.EnumValue)this.builder.push("blockmode").defineEnum(ClimbeyBlockmode.DISABLED, ClimbeyBlockmode.class).setPacketFunction((v, p) -> PacketUtils.getClimbeyServerPayload(p));
        this.climbeyBlocklist = (ConfigBuilder.StringListValue)this.builder.push("blocklist").defineStringList(mc.major > 12 ? Arrays.asList("white_wool", "dirt", "grass_block") : Arrays.asList("wool:0", "dirt", "grass")).setPacketFunction((v, p) -> PacketUtils.getClimbeyServerPayload(p));
        this.builder.pop();
        this.builder.push("crawling");
        this.crawlingEnabled = (ConfigBuilder.BooleanValue)((ConfigBuilder.ConfigValue)this.builder.push("enabled").define(true).setOnUpdate(nV -> {
            if (!nV.booleanValue()) {
                ViveMain.VIVE_PLAYERS.values().forEach(vp -> {
                    vp.crawling = false;
                });
            }
        })).setPacketFunction(ViveMain.MC != null && ViveMain.MC.supportsCrawling() ? (v, p) -> new CrawlPayloadS2C((boolean)v, p.networkVersion) : null);
        this.builder.pop();
        this.builder.push("teleport");
        this.teleportEnabled = (ConfigBuilder.BooleanValue)this.builder.push("enabled").define(true).setPacketFunction((v, p) -> new TeleportPayloadS2C((boolean)v, p.networkVersion));
        this.teleportLimitedSurvival = (ConfigBuilder.BooleanValue)this.builder.push("limitedSurvival").define(false).setPacketFunction((v, p) -> PacketUtils.getSurvivalTeleportOverridePayload());
        this.teleportUpLimit = (ConfigBuilder.IntValue)this.builder.push("upLimit").defineInRange(4, 1, 16).setPacketFunction((v, p) -> PacketUtils.getSurvivalTeleportOverridePayload());
        this.teleportDownLimit = (ConfigBuilder.IntValue)this.builder.push("downLimit").defineInRange(4, 1, 16).setPacketFunction((v, p) -> PacketUtils.getSurvivalTeleportOverridePayload());
        this.teleportHorizontalLimit = (ConfigBuilder.IntValue)this.builder.push("horizontalLimit").defineInRange(16, 1, 32).setPacketFunction((v, p) -> PacketUtils.getSurvivalTeleportOverridePayload());
        this.builder.pop();
        this.builder.push("worldScale");
        this.worldscaleLimited = (ConfigBuilder.BooleanValue)this.builder.push("limitRange").define(false).setPacketFunction((v, p) -> PacketUtils.getWorldScaleOverridePayload());
        this.worldscaleMin = (ConfigBuilder.DoubleValue)this.builder.push("min").defineInRange(0.5, 0.1, 100.0).setPacketFunction((v, p) -> PacketUtils.getWorldScaleOverridePayload());
        this.worldscaleMax = (ConfigBuilder.DoubleValue)this.builder.push("max").defineInRange(2.0, 0.1, 100.0).setPacketFunction((v, p) -> PacketUtils.getWorldScaleOverridePayload());
        this.builder.pop();
        this.builder.push("settingOverrides");
        this.forceThirdPersonItems = (ConfigBuilder.BooleanValue)this.builder.push("thirdPersonItems").define(false).setPacketFunction((v, p) -> PacketUtils.getThirdPersonItemsOverridePayload());
        this.forceThirdPersonItemsCustom = (ConfigBuilder.BooleanValue)this.builder.push("thirdPersonItemsCustom").define(false).setPacketFunction((v, p) -> PacketUtils.getThirdPersonItemsCustomOverridePayload());
        this.builder.pop();
        this.builder.push("vrSwitching");
        this.vrSwitchingEnabled = (ConfigBuilder.BooleanValue)this.builder.push("enabled").define(true).setPacketFunction((v, p) -> PacketUtils.getVRSwitchingPayload());
        this.builder.pop();
        this.builder.push("debug");
        this.debug = this.builder.push("debugLogging").define(false);
        this.builder.push("particles");
        this.debugParticlesEnabled = (ConfigBuilder.BooleanValue)this.builder.push("enabled").define(false).setOnUpdate(nV -> ViveMain.INSTANCE.toggleParticleTask((boolean)nV));
        this.debugParticlesOpOnly = this.builder.push("opOnly").define(true);
        this.debugParticlesVrDevice = this.builder.push("vrDevices").define(false);
        this.debugParticlesVrHead = this.builder.push("vrHead").define(false);
        this.debugParticlesHeadHitbox = this.builder.push("headHitbox").define(false);
        this.builder.pop();
        this.builder.pop();
        for (ConfigBuilder.ConfigValue configValue : this.builder.getConfigValues()) {
            ConfigBuilder.EnumValue enumValue;
            if (!(configValue instanceof ConfigBuilder.EnumValue) || (enumValue = (ConfigBuilder.EnumValue)configValue).get() == null) continue;
            enumValue.set(enumValue.getEnumValue(enumValue.get()), null);
        }
        this.builder.correct(s -> this.plugin.getLogger().warning(s.replaceAll("\u00a7.", "")));
        this.save();
    }

    public int reload(Consumer<String> notifier) {
        this.plugin.reloadConfig();
        int changes = this.builder.setNewConfigFile(this.plugin.getConfig(), true, notifier);
        this.save();
        return changes;
    }

    public void save() {
        if (this.inMemory) {
            return;
        }
        this.plugin.saveConfig();
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        List<String> lines = this.commentLines(configFile);
        if (lines == null || !this.writeLinesToFile(configFile, lines)) {
            this.plugin.getLogger().severe("Failed to comment config file");
            return;
        }
        this.plugin.reloadConfig();
        this.builder.setNewConfigFile(this.plugin.getConfig(), false, this.plugin.getLogger()::warning);
    }

    public List<ConfigBuilder.ConfigValue> getConfigValues() {
        return this.builder.getConfigValues();
    }

    public List<String> commentLines(File file) {
        ArrayList<String> arrayList;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            String indent = null;
            ArrayDeque<String> stack = new ArrayDeque<String>();
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
                if (trimmed.contains(":") && !trimmed.startsWith("-")) {
                    String newIndent = line.substring(0, line.indexOf(trimmed));
                    String entry = trimmed.substring(0, trimmed.indexOf(":"));
                    boolean leaf = false;
                    if (trimmed.endsWith(":")) {
                        if (indent == null || newIndent.length() >= indent.length()) {
                            stack.add(entry);
                        } else if (newIndent.isEmpty()) {
                            stack.clear();
                            stack.add(entry);
                            lines.add("");
                        } else {
                            stack.removeLast();
                            stack.add(entry);
                        }
                    } else {
                        stack.add(entry);
                        leaf = true;
                    }
                    indent = newIndent;
                    String tString = "vivecraft.serverSettings." + String.join((CharSequence)".", stack);
                    if (!leaf) {
                        this.addComments(lines, indent, tString, false);
                    }
                    this.addComments(lines, indent, tString + ".tooltip", leaf);
                    this.addComments(lines, indent, tString + ".tooltipall", false);
                    this.addComments(lines, indent, tString + ".tooltipspigot", false);
                    ConfigBuilder.ConfigValue c = this.builder.getConfigValue(String.join((CharSequence)".", stack));
                    if (c instanceof ConfigBuilder.NumberValue) {
                        ConfigBuilder.NumberValue n = (ConfigBuilder.NumberValue)c;
                        lines.add(indent + String.format("# default: %s, min: %s, max: %s", n.getDefaultValue(), n.getMin(), n.getMax()));
                    }
                    if (leaf) {
                        stack.removeLast();
                    }
                }
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "error commenting config: ", e);
                return null;
            }
        }
        reader.close();
        return arrayList;
    }

    private void addComments(List<String> lines, String indent, String key, boolean required) {
        if (ViveMain.TRANSLATIONS.containsKey(key)) {
            String comment = ViveMain.TRANSLATIONS.get(key);
            comment = comment.replaceAll("\u00a7.", "");
            for (String s : comment.split("\n")) {
                if (s.trim().isEmpty()) continue;
                lines.add(indent + "#" + s);
            }
        } else if (required) {
            this.plugin.getLogger().severe("no comment for key: " + key);
        }
    }

    public boolean writeLinesToFile(File file, List<String> lines) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String line : lines) {
                writer.write(line + "\n");
            }
            writer.flush();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to comment config file2");
            return false;
        }
        return true;
    }
}

