/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.util.Vector;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api_impl.data.VRBodyPartDataImpl;
import org.vivecraft.util.BufferUtils;
import org.vivecraft.util.MathUtils;

public final class Pose {
    public final Vector3fc position;
    public final Quaternionfc orientation;

    public Pose(Vector3fc position, Quaternionfc orientation) {
        this.position = position;
        this.orientation = orientation;
    }

    public Pose offset(Vector offset) {
        return new Pose(new Vector3f((float)((double)this.position.x() + offset.getX()), (float)((double)this.position.y() + offset.getY()), (float)((double)this.position.z() + offset.getZ())), this.orientation);
    }

    public static Pose deserialize(DataInputStream buffer) throws IOException {
        return new Pose(BufferUtils.readVector3f(buffer), BufferUtils.readQuat(buffer));
    }

    public void serialize(DataOutputStream buffer) throws IOException {
        BufferUtils.writeVector3f(buffer, this.position);
        BufferUtils.writeQuat(buffer, this.orientation);
    }

    public VRBodyPartData asBodyPartData(Vector playerPos) {
        return new VRBodyPartDataImpl(MathUtils.toBukkitVec(this.position).add(playerPos), MathUtils.toBukkitVec(this.orientation.transform(MathUtils.BACK, new Vector3f())), this.orientation);
    }
}

