/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api_impl.data.VRPoseImpl;
import org.vivecraft.data.Pose;
import org.vivecraft.network.NetworkVersion;

public final class VrPlayerState {
    public final boolean seated;
    public final Pose hmd;
    public final boolean leftHanded;
    public final Pose mainHand;
    public final boolean reverseHands1legacy;
    public final Pose offHand;
    public final FBTMode fbtMode;
    @Nullable
    public final Pose waist;
    @Nullable
    public final Pose rightFoot;
    @Nullable
    public final Pose leftFoot;
    @Nullable
    public final Pose rightKnee;
    @Nullable
    public final Pose leftKnee;
    @Nullable
    public final Pose rightElbow;
    @Nullable
    public final Pose leftElbow;

    public VrPlayerState(boolean seated, Pose hmd, boolean leftHanded, Pose mainHand, boolean reverseHands1legacy, Pose offHand, FBTMode fbtMode, @Nullable Pose waist, @Nullable Pose rightFoot, @Nullable Pose leftFoot, @Nullable Pose rightKnee, @Nullable Pose leftKnee, @Nullable Pose rightElbow, @Nullable Pose leftElbow) {
        this.seated = seated;
        this.hmd = hmd;
        this.leftHanded = leftHanded;
        this.mainHand = mainHand;
        this.reverseHands1legacy = reverseHands1legacy;
        this.offHand = offHand;
        this.fbtMode = fbtMode;
        this.waist = waist;
        this.rightFoot = rightFoot;
        this.leftFoot = leftFoot;
        this.rightKnee = rightKnee;
        this.leftKnee = leftKnee;
        this.rightElbow = rightElbow;
        this.leftElbow = leftElbow;
    }

    public VrPlayerState(VrPlayerState other, NetworkVersion version, @Nullable Vector offset) {
        this(other.seated, offset == null ? other.hmd : other.hmd.offset(offset), other.leftHanded, offset == null ? other.mainHand : other.mainHand.offset(offset), other.reverseHands1legacy, offset == null ? other.offHand : other.offHand.offset(offset), NetworkVersion.FBT.accepts(version) ? other.fbtMode : FBTMode.ARMS_ONLY, NetworkVersion.FBT.accepts(version) ? other.waist : null, NetworkVersion.FBT.accepts(version) ? other.rightFoot : null, NetworkVersion.FBT.accepts(version) ? other.leftFoot : null, NetworkVersion.FBT.accepts(version) ? other.rightKnee : null, NetworkVersion.FBT.accepts(version) ? other.leftKnee : null, NetworkVersion.FBT.accepts(version) ? other.rightElbow : null, NetworkVersion.FBT.accepts(version) ? other.leftElbow : null);
    }

    public static VrPlayerState deserialize(DataInputStream buffer, int bytesAfter) throws IOException {
        boolean seated = buffer.readBoolean();
        Pose hmd = Pose.deserialize(buffer);
        boolean reverseHands = buffer.readBoolean();
        Pose mainController = Pose.deserialize(buffer);
        boolean reverseHandsLegacy = buffer.readBoolean();
        Pose offController = Pose.deserialize(buffer);
        FBTMode fbtMode = FBTMode.ARMS_ONLY;
        Pose waist = null;
        Pose rightFoot = null;
        Pose leftFoot = null;
        Pose rightKnee = null;
        Pose leftKnee = null;
        Pose rightElbow = null;
        Pose leftElbow = null;
        if (buffer.available() > bytesAfter) {
            fbtMode = FBTMode.values()[buffer.readByte()];
        }
        if (fbtMode != FBTMode.ARMS_ONLY) {
            waist = Pose.deserialize(buffer);
            rightFoot = Pose.deserialize(buffer);
            leftFoot = Pose.deserialize(buffer);
        }
        if (fbtMode == FBTMode.WITH_JOINTS) {
            rightKnee = Pose.deserialize(buffer);
            leftKnee = Pose.deserialize(buffer);
            rightElbow = Pose.deserialize(buffer);
            leftElbow = Pose.deserialize(buffer);
        }
        return new VrPlayerState(seated, hmd, reverseHands, mainController, reverseHandsLegacy, offController, fbtMode, waist, rightFoot, leftFoot, rightKnee, leftKnee, rightElbow, leftElbow);
    }

    @Nullable
    public Pose getBodyPartPose(VRBodyPart bodyPart) {
        switch (bodyPart) {
            case MAIN_HAND: {
                return this.mainHand;
            }
            case OFF_HAND: {
                return this.offHand;
            }
            case LEFT_FOOT: {
                return this.leftFoot;
            }
            case RIGHT_FOOT: {
                return this.rightFoot;
            }
            case LEFT_ELBOW: {
                return this.leftElbow;
            }
            case RIGHT_ELBOW: {
                return this.rightElbow;
            }
            case LEFT_KNEE: {
                return this.leftKnee;
            }
            case RIGHT_KNEE: {
                return this.rightKnee;
            }
            case WAIST: {
                return this.waist;
            }
            case HEAD: {
                return this.hmd;
            }
        }
        return this.mainHand;
    }

    public void serialize(DataOutputStream buffer) throws IOException {
        buffer.writeBoolean(this.seated);
        this.hmd.serialize(buffer);
        buffer.writeBoolean(this.leftHanded);
        this.mainHand.serialize(buffer);
        buffer.writeBoolean(this.leftHanded);
        this.offHand.serialize(buffer);
        if (this.fbtMode != FBTMode.ARMS_ONLY) {
            buffer.writeByte(this.fbtMode.ordinal());
            this.waist.serialize(buffer);
            this.rightFoot.serialize(buffer);
            this.leftFoot.serialize(buffer);
            if (this.fbtMode == FBTMode.WITH_JOINTS) {
                this.rightKnee.serialize(buffer);
                this.leftKnee.serialize(buffer);
                this.rightElbow.serialize(buffer);
                this.leftElbow.serialize(buffer);
            }
        }
    }

    public VRPoseImpl asVRPose(Vector playerPos) {
        return new VRPoseImpl(this.hmd.asBodyPartData(playerPos), this.mainHand.asBodyPartData(playerPos), this.offHand.asBodyPartData(playerPos), VrPlayerState.getDataOrNull(this.rightFoot, playerPos), VrPlayerState.getDataOrNull(this.leftFoot, playerPos), VrPlayerState.getDataOrNull(this.waist, playerPos), VrPlayerState.getDataOrNull(this.rightKnee, playerPos), VrPlayerState.getDataOrNull(this.leftKnee, playerPos), VrPlayerState.getDataOrNull(this.rightElbow, playerPos), VrPlayerState.getDataOrNull(this.leftElbow, playerPos), this.seated, this.leftHanded, this.fbtMode);
    }

    @Nullable
    private static VRBodyPartData getDataOrNull(Pose pose, Vector playerPos) {
        return pose == null ? null : pose.asBodyPartData(playerPos);
    }
}

