/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.compat.types.Particles;
import org.vivecraft.data.VrPlayerState;
import org.vivecraft.util.AABB;
import org.vivecraft.util.Headshot;
import org.vivecraft.util.MCVersion;
import org.vivecraft.util.MathUtils;

public class Debug {
    private static final Vector RED = new Vector(1, 0, 0);
    private static final Vector GREEN = new Vector(0, 1, 0);
    private static final Vector BLUE = new Vector(0, 0, 1);

    public static void log(String msg, Object ... args) {
        if (ViveMain.CONFIG != null && ((Boolean)ViveMain.CONFIG.debug.get()).booleanValue()) {
            if (args != null && args.length > 0) {
                Object[] s = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    s[i] = String.valueOf(args[i]);
                }
                ViveMain.LOGGER.info(String.format(msg, s));
            } else {
                ViveMain.LOGGER.info(msg);
            }
        }
    }

    public static void debugParticles() {
        for (World w : Bukkit.getWorlds()) {
            HashSet<Entity> set = new HashSet<Entity>();
            for (Player player : w.getPlayers()) {
                if (((Boolean)ViveMain.CONFIG.debugParticlesOpOnly.get()).booleanValue() != player.isOp() && !player.isOp()) continue;
                for (Entity e : player.getNearbyEntities(20.0, 20.0, 20.0)) {
                    Debug.spawnParticles(set, w, e);
                }
                Debug.spawnParticles(set, w, (Entity)player);
                if (!set.contains(player)) {
                    Debug.spawnAABBParticles(w, Headshot.getHeadHitbox((Entity)player));
                }
                set.add((Entity)player);
            }
        }
    }

    private static void spawnParticles(Set<Entity> set, World world, Entity entity) {
        if (set.contains(entity)) {
            return;
        }
        if (((Boolean)ViveMain.CONFIG.debugParticlesHeadHitbox.get()).booleanValue()) {
            Debug.spawnAABBParticles(world, Headshot.getHeadHitbox(entity));
        }
        if (ViveMain.isVivePlayer(entity)) {
            VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)((Player)entity));
            VrPlayerState vrPlayerState = vivePlayer.vrPlayerState();
            if (vivePlayer.isVR() && vrPlayerState != null) {
                if (((Boolean)ViveMain.CONFIG.debugParticlesVrDevice.get()).booleanValue()) {
                    for (VRBodyPart bodyPart : VRBodyPart.values()) {
                        if (!bodyPart.availableInMode(vrPlayerState.fbtMode) || bodyPart == VRBodyPart.HEAD) continue;
                        Debug.debugParticleAxes(entity.getWorld(), vivePlayer.getBodyPartPos(bodyPart), vrPlayerState.getBodyPartPose((VRBodyPart)bodyPart).orientation);
                    }
                }
                if (((Boolean)ViveMain.CONFIG.debugParticlesVrHead.get()).booleanValue()) {
                    Debug.debugParticleAxes(entity.getWorld(), vivePlayer.getHMDPos(), vivePlayer.vrPlayerState().hmd.orientation);
                }
            }
        }
        set.add(entity);
    }

    public static void debugParticleAxes(World world, Vector position, Quaternionfc rot) {
        Vector3f forward = rot.transform(MathUtils.BACK, new Vector3f());
        Vector3f up = rot.transform(MathUtils.UP, new Vector3f());
        Vector3f right = rot.transform(MathUtils.RIGHT, new Vector3f());
        Debug.spawnParticlesDirection(world, BLUE, position, forward);
        Debug.spawnParticlesDirection(world, GREEN, position, up);
        Debug.spawnParticlesDirection(world, RED, position, right);
    }

    public static void spawnParticlesDirection(World world, Vector color, Vector position, Vector3f direction) {
        for (int i = 0; i < 5; ++i) {
            Vector3f offset = direction.mul((MCVersion.getCurrent().major < 13 ? 0.5f : 0.25f) / 4.0f * (float)i, new Vector3f());
            ViveMain.API.spawnParticle(Particles.DEBUG, world, new Vector(position.getX() + (double)offset.x, position.getY() + (double)offset.y, position.getZ() + (double)offset.z), 1, color, 0.0, false, null);
        }
    }

    private static void spawnAABBParticles(World world, AABB aabb) {
        if (aabb == null) {
            return;
        }
        ArrayList<Vector> vs = new ArrayList<Vector>();
        vs.add(new Vector(aabb.minX, aabb.minY, aabb.minZ));
        vs.add(new Vector(aabb.minX, aabb.maxY, aabb.minZ));
        vs.add(new Vector(aabb.maxX, aabb.minY, aabb.minZ));
        vs.add(new Vector(aabb.maxX, aabb.maxY, aabb.minZ));
        vs.add(new Vector(aabb.minX, aabb.minY, aabb.maxZ));
        vs.add(new Vector(aabb.minX, aabb.maxY, aabb.maxZ));
        vs.add(new Vector(aabb.maxX, aabb.minY, aabb.maxZ));
        vs.add(new Vector(aabb.maxX, aabb.maxY, aabb.maxZ));
        for (Vector v : vs) {
            ViveMain.API.spawnParticle(Particles.DEBUG, world, v, 1, RED, 0.0, true, null);
        }
    }
}

