/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.events;

import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.util.Vector;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.compat.Platform;
import org.vivecraft.compat.types.Particles;
import org.vivecraft.config.enums.HeadshotIndicator;
import org.vivecraft.util.Headshot;
import org.vivecraft.util.MathUtils;

public class ProjectileEvents
implements Listener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void vrProjectileDirection(ProjectileLaunchEvent event) {
        Player player;
        VivePlayer vivePlayer;
        Projectile proj = event.getEntity();
        if (proj.getShooter() instanceof Player && (vivePlayer = ViveMain.getVivePlayer((Entity)(player = (Player)proj.getShooter()))) != null && vivePlayer.isVR()) {
            boolean arrow = ViveMain.MC.isArrow((Entity)proj);
            Vector3f view = ViveMain.NMS.getViewVector((Entity)player);
            Vector projDir = proj.getVelocity().normalize();
            Quaternionf rotation = new Quaternionf(vivePlayer.getAimOrientation(true));
            boolean isMainArrow = false;
            if (view.dot((float)projDir.getX(), (float)projDir.getY(), (float)projDir.getZ()) > 0.996f) {
                rotation.rotateTo(view.x, view.y, view.z, (float)projDir.getX(), (float)projDir.getY(), (float)projDir.getZ());
                isMainArrow = true;
            } else {
                float yView = (float)Math.atan2(-view.x(), view.z());
                float yProj = (float)Math.atan2(-projDir.getX(), projDir.getZ());
                float multishotOffset = yProj - yView;
                rotation.rotateY(multishotOffset);
            }
            Vector pos = vivePlayer.getAimPos(true);
            Vector3f aimF = rotation.transform(MathUtils.BACK, new Vector3f());
            if (isMainArrow && (Double)ViveMain.CONFIG.projectileInaccuracyMultiplier.get() < 1.0) {
                aimF.lerp(vivePlayer.getAimDir(true), 1.0f - ((Double)ViveMain.CONFIG.projectileInaccuracyMultiplier.get()).floatValue());
            }
            Vector aim = MathUtils.toBukkitVec(aimF);
            double velocity = 1.0;
            if (arrow && vivePlayer.draw != 0.0f && !vivePlayer.isSeated()) {
                velocity = vivePlayer.draw;
            }
            Location loc = new Location(proj.getWorld(), pos.getX(), pos.getY(), pos.getZ());
            loc.setDirection(aim);
            loc.setPitch(-loc.getPitch());
            loc.setYaw(-loc.getYaw());
            double velo = proj.getVelocity().length();
            Platform.getInstance().teleportEntity((Entity)proj, loc, aim.multiply(velo * velocity));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void arrowDamageMultiplier(EntityDamageByEntityEvent event) {
        if (!ViveMain.MC.isArrow(event.getDamager())) {
            return;
        }
        if (event.getDamager() instanceof Arrow) {
            Arrow arrow = (Arrow)event.getDamager();
            if (!(arrow.getShooter() instanceof Player)) {
                return;
            }
            Player player = (Player)arrow.getShooter();
            VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
            Vector hitPos = Headshot.isHeadshot((Projectile)arrow, event.getEntity());
            double multiplier = 1.0;
            if (hitPos != null) {
                multiplier = vivePlayer != null && vivePlayer.isVR() ? (vivePlayer.isSeated() ? ((Double)ViveMain.CONFIG.bowSeatedHeadshotMultiplier.get()).doubleValue() : ((Double)ViveMain.CONFIG.bowStandingHeadshotMultiplier.get()).doubleValue()) : (Double)ViveMain.CONFIG.bowVanillaHeadshotMultiplier.get();
                if (multiplier > 1.0 && ViveMain.CONFIG.bowHeadshotIndicator.get() != HeadshotIndicator.NONE) {
                    if (ViveMain.CONFIG.bowHeadshotIndicator.get() != HeadshotIndicator.AUDIO) {
                        ViveMain.API.spawnParticle(Particles.CRIT, player.getWorld(), hitPos, 5, arrow.getVelocity().multiply(-1), 0.1, true, null);
                    }
                    if (ViveMain.CONFIG.bowHeadshotIndicator.get() != HeadshotIndicator.VISUAL) {
                        player.playSound(player.getLocation(), ViveMain.API.getBreakingSound(), 0.7f, 0.5f);
                    }
                }
            }
            if (vivePlayer != null && vivePlayer.isVR()) {
                multiplier = vivePlayer.isSeated() ? Math.max(multiplier, (Double)ViveMain.CONFIG.bowSeatedMultiplier.get()) : Math.max(multiplier, (Double)ViveMain.CONFIG.bowStandingMultiplier.get());
            }
            event.setDamage(event.getDamage() * multiplier);
        }
    }
}

