/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.joml.Vector3fc;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.compat.Platform;
import org.vivecraft.data.PlayerState;
import org.vivecraft.debug.Debug;

public class AimFixHandler
extends ChannelInboundHandlerAdapter {
    private final Object netManager;
    private final UUID palyerId;

    public AimFixHandler(Player player, Object netManager) {
        this.netManager = netManager;
        this.palyerId = player.getUniqueId();
        ViveMain.NMS.getChannel(netManager).pipeline().addBefore("packet_handler", "vr_aim_fix", (ChannelHandler)this);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object listener = ViveMain.NMS.getPacketListener(this.netManager);
        if (!(ViveMain.VIVE_PLAYERS.containsKey(this.palyerId) && ViveMain.VIVE_PLAYERS.get(this.palyerId).isVR() && ViveMain.NMS.needsAimfixHandling(msg))) {
            ctx.fireChannelRead(msg);
            return;
        }
        Object player = ViveMain.NMS.getPlayer(listener);
        Runnable task = () -> {
            PlayerState oldState = ViveMain.NMS.getPlayerState(player);
            VivePlayer vivePlayer = ViveMain.VIVE_PLAYERS.get(this.palyerId);
            float xRot = oldState.xRot;
            float yRot = oldState.yRot;
            Vector aimPos = null;
            if (vivePlayer != null && vivePlayer.isVR()) {
                aimPos = vivePlayer.getAimPos(false);
                Vector3fc dir = ViveMain.NMS.getHitDirIfGate(player, msg);
                if (dir == null) {
                    dir = vivePlayer.getAimDir(false);
                }
                xRot = (float)Math.toDegrees(Math.asin(-dir.y()));
                yRot = (float)Math.toDegrees(Math.atan2(-dir.x(), dir.z()));
                ViveMain.NMS.setPlayerState(player, aimPos, xRot, yRot);
                vivePlayer.offset.setX(oldState.x - aimPos.getX());
                vivePlayer.offset.setY(oldState.y - aimPos.getY());
                vivePlayer.offset.setZ(oldState.z - aimPos.getZ());
                Debug.log("AimFix: pos: %s, dir: %s", aimPos, dir);
            }
            try {
                if (ViveMain.NMS.isConnectionConnected(this.netManager)) {
                    try {
                        ViveMain.NMS.handlePacket(player, msg, listener, xRot, yRot);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
            if (ViveMain.NMS.restorePlayerState(player, oldState, aimPos)) {
                Debug.log("AimFix: AimFix moved Player", new Object[0]);
            }
            if (vivePlayer != null) {
                vivePlayer.offset.zero();
            }
        };
        if (Platform.FOLIA) {
            Platform.getInstance().getScheduler().runEntity((Entity)Bukkit.getPlayer((UUID)this.palyerId), task);
        } else {
            ViveMain.NMS.handlePacketTask(listener, task, player);
        }
    }
}

