/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.vivecraft.ViveMain;
import org.vivecraft.VivePlayer;
import org.vivecraft.debug.Debug;

public class NetworkUtils {
    public static void sendMessageToAll(String message, String playerName, String cause) {
        if (!message.isEmpty()) {
            Bukkit.getServer().broadcastMessage(NetworkUtils.formatMessage(message, playerName, cause));
        }
    }

    public static String formatMessage(String message, String playerName, String cause) {
        message = message.replace("&player", playerName);
        message = message.replace("&cause", cause);
        return message;
    }

    public static boolean kickIfNotAllowed(Player player) {
        if (player.isOnline()) {
            boolean isOpAndAllowed;
            VivePlayer vivePlayer = ViveMain.getVivePlayer((Entity)player);
            boolean bl = isOpAndAllowed = (Boolean)ViveMain.CONFIG.allowOp.get() != false && player.isOp();
            if (!(isOpAndAllowed || !((Boolean)ViveMain.CONFIG.vrOnly.get()).booleanValue() || vivePlayer != null && vivePlayer.isVR())) {
                String kickMessage = (String)ViveMain.CONFIG.messagesKickVrOnly.get();
                player.kickPlayer(NetworkUtils.formatMessage(kickMessage, player.getName(), ""));
                Debug.log(player.getName() + " got kicked for not using VR", new Object[0]);
                return true;
            }
            if (!isOpAndAllowed && ((Boolean)ViveMain.CONFIG.viveOnly.get()).booleanValue() && vivePlayer == null) {
                String kickMessage = (String)ViveMain.CONFIG.messagesKickViveOnly.get();
                player.kickPlayer(NetworkUtils.formatMessage(kickMessage, player.getName(), ""));
                Debug.log(player.getName() + " got kicked for not using Vivecraft", new Object[0]);
                return true;
            }
        }
        return false;
    }
}

