/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network;

public enum NetworkVersion {
    LEGACY,
    NEW_NETWORKING,
    FBT,
    DUAL_WIELDING,
    HEAD_AIM,
    HAPTIC_PACKET,
    SERVER_VR_CHANGES,
    DAMAGE_DIRECTION,
    OPTION_TOGGLE;


    public static NetworkVersion fromProtocolVersion(int protocolVersion) {
        return NetworkVersion.values()[protocolVersion + 1];
    }

    public int protocolVersion() {
        return this.ordinal() - 1;
    }

    public String getViveVersion() {
        switch (this.ordinal()) {
            case 0: {
                return "legacy";
            }
            case 1: {
                return "1.0.0";
            }
            case 2: 
            case 3: {
                return "1.2.0";
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "1.3.0";
            }
        }
        return "unknown";
    }

    public boolean accepts(NetworkVersion other) {
        return this.ordinal() <= other.ordinal();
    }

    public String toString() {
        return this.name() + ": " + this.protocolVersion();
    }
}

