/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network.packet.c2s;

import java.io.DataInputStream;
import java.io.IOException;
import org.vivecraft.network.NetworkVersion;
import org.vivecraft.network.packet.PayloadIdentifier;
import org.vivecraft.network.packet.c2s.VivecraftPayloadC2S;

public final class VersionPayloadC2S
implements VivecraftPayloadC2S {
    public final String version;
    public final boolean vr;
    public final int maxVersion;
    public final int minVersion;
    public final boolean legacy;

    public VersionPayloadC2S(String version, boolean vr, int maxVersion, int minVersion, boolean legacy) {
        this.version = version;
        this.vr = vr;
        this.maxVersion = maxVersion;
        this.minVersion = minVersion;
        this.legacy = legacy;
    }

    public VersionPayloadC2S(String version, boolean vr, int maxVersion, int minVersion) {
        this(version, vr, maxVersion, minVersion, false);
    }

    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.VERSION;
    }

    public static VersionPayloadC2S read(DataInputStream buffer) throws IOException {
        boolean vr;
        byte[] stringBytes = new byte[buffer.available()];
        buffer.read(stringBytes);
        String[] parts = new String(stringBytes).split("\\n");
        boolean bl = vr = !parts[0].contains("NONVR");
        if (parts.length >= 3) {
            return new VersionPayloadC2S(parts[0], vr, Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), false);
        }
        return new VersionPayloadC2S(parts[0], vr, NetworkVersion.LEGACY.protocolVersion(), NetworkVersion.LEGACY.protocolVersion(), true);
    }
}

