/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network.packet.s2c;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.config.enums.ClimbeyBlockmode;
import org.vivecraft.network.packet.PayloadIdentifier;
import org.vivecraft.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.util.BufferUtils;

public final class ClimbingPayloadS2C
implements VivecraftPayloadS2C {
    public final boolean allowed;
    public final ClimbeyBlockmode blockmode;
    @Nullable
    public final List<String> blocks;

    public ClimbingPayloadS2C(boolean allowed, ClimbeyBlockmode blockmode, @Nullable List<String> blocks) {
        this.allowed = allowed;
        this.blockmode = blockmode;
        this.blocks = blocks;
    }

    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.CLIMBING;
    }

    @Override
    public void write(DataOutputStream buffer) throws IOException {
        buffer.writeByte(this.payloadId().ordinal());
        buffer.writeBoolean(this.allowed);
        buffer.writeByte(this.blockmode.ordinal());
        if (this.blocks != null) {
            for (String block : this.blocks) {
                BufferUtils.writeMCString(buffer, block);
            }
        }
    }
}

