/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.network.packet.s2c;

import java.io.DataOutputStream;
import java.io.IOException;
import org.vivecraft.network.NetworkVersion;
import org.vivecraft.network.packet.PayloadIdentifier;
import org.vivecraft.network.packet.s2c.VivecraftPayloadS2C;

public final class TeleportPayloadS2C
implements VivecraftPayloadS2C {
    public final boolean allowed;
    public final NetworkVersion targetNetworkVersion;

    public TeleportPayloadS2C(boolean allowed, NetworkVersion targetNetworkVersion) {
        this.allowed = allowed;
        this.targetNetworkVersion = targetNetworkVersion;
    }

    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.TELEPORT;
    }

    @Override
    public void write(DataOutputStream buffer) throws IOException {
        buffer.writeByte(this.payloadId().ordinal());
        if (NetworkVersion.OPTION_TOGGLE.accepts(this.targetNetworkVersion)) {
            buffer.writeBoolean(this.allowed);
        }
    }
}

