/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.util;

import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.ViveMain;
import org.vivecraft.util.AABB;

public class Headshot {
    private static final double INFLATE = 0.3;

    public static Vector isHeadshot(Projectile projectile, Entity target) {
        AABB headBox = Headshot.getHeadHitbox(target);
        if (headBox != null) {
            Vector projPos = projectile.getLocation().toVector();
            Vector originalHitPos = ViveMain.API.getEntityAABB(target).clip(projPos, new Vector().copy(projPos).add(projectile.getVelocity().multiply(2.0))).orElse(new Vector().copy(projPos).add(projectile.getVelocity()));
            return headBox.clip(projPos, originalHitPos).orElse((Vector)(headBox.contains(projPos) ? projPos : null));
        }
        return null;
    }

    @Nullable
    public static AABB getHeadHitbox(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (ViveMain.MC.hasHumanoidHead(livingEntity)) {
            Vector headPos = livingEntity.getEyeLocation().toVector();
            double headsize = (double)ViveMain.API.getEntityWidth((Entity)livingEntity) * 0.5;
            if (livingEntity instanceof Ageable && !((Ageable)livingEntity).isAdult()) {
                headsize *= 1.2;
            }
            return new AABB(headPos.getX() - headsize, headPos.getY() - headsize + 0.3, headPos.getZ() - headsize, headPos.getX() + headsize, headPos.getY() + headsize + 0.3, headPos.getZ() + headsize).inflate(0.3);
        }
        if (ViveMain.MC.hasAnimalHead(livingEntity)) {
            Location loc = livingEntity.getEyeLocation();
            float yRot = -ViveMain.NMS.getLivingEntityBodyYaw(livingEntity) * ((float)Math.PI / 180);
            double entityWidth = ViveMain.API.getEntityWidth((Entity)livingEntity);
            Vector headPos = new Vector(loc.getX() + Math.sin(yRot) * entityWidth * 0.5, loc.getY(), loc.getZ() + Math.cos(yRot) * entityWidth * 0.5);
            double headsize = entityWidth * 0.25;
            if (livingEntity instanceof Ageable && !((Ageable)livingEntity).isAdult()) {
                headsize *= 1.5;
            }
            return new AABB(headPos.getX() - headsize, headPos.getY() - headsize, headPos.getZ() - headsize, headPos.getX() + headsize, headPos.getY() + headsize, headPos.getZ() + headsize).inflate(0.075).expandTowards(headPos.subtract(entity.getLocation().toVector()).multiply(0.3));
        }
        return null;
    }
}

