/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.vivecraft.util.MCVersion;

public class Utils {
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d{1,2}\\.\\d{1,2}(\\.\\d{1,2})?");

    public static Map<String, String> MapOf(String ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Map entries need to be an even number of arguments");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return map;
    }

    @SafeVarargs
    public static <K> List<K> ListOf(K ... args) {
        if (args == null || args.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<K> list = new ArrayList<K>(args.length);
        for (int i = 0; i < args.length; i += 2) {
            list.add(args[i]);
        }
        return list;
    }

    public static boolean containsAll(Collection<?> a, Collection<?> b) {
        for (Object o : a) {
            if (o == null || b.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static MCVersion getMCVersion(String viveVersion) {
        Matcher m = VERSION_PATTERN.matcher(viveVersion);
        if (m.find()) {
            return MCVersion.parse(m.group(), false);
        }
        return MCVersion.INVALID;
    }

    public static String gold(Object o) {
        return Utils.padColor(o, ChatColor.GOLD);
    }

    public static String red(Object o) {
        return Utils.padColor(o, ChatColor.RED);
    }

    public static String green(Object o) {
        return Utils.padColor(o, ChatColor.GREEN);
    }

    public static String padColor(Object o, ChatColor color) {
        return color + o.toString() + ChatColor.RESET;
    }
}

