/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.util.reflection;

import me.kcra.takenaka.accessor.mapping.ClassMapping;
import org.vivecraft.util.MCVersion;

public class ClassGetter {
    public static Class<?> getClass(boolean critical, ClassMapping ... mappings) {
        MCVersion mc = MCVersion.getCurrentCorrected();
        Class<?> c = null;
        for (String namespace : new String[]{"spigot", "mojang"}) {
            for (ClassMapping mapping : mappings) {
                int minor = mc.minor;
                for (int major = mc.major; major > 7 && c == null; --major) {
                    while (minor >= 0 && c == null) {
                        c = minor == 0 ? mapping.getClass("1." + major, namespace) : mapping.getClass("1." + major + "." + minor, namespace);
                        --minor;
                    }
                    minor = 10;
                }
                if (c == null && mc.major <= 8) {
                    c = mapping.getClass("1.8.8", namespace);
                }
                if (c != null) break;
            }
            if (c != null) break;
        }
        if (c == null && critical) {
            throw new RuntimeException("Unsupported mc version: " + mc.version + ", no mapping found for: " + mappings[0].getName());
        }
        return c;
    }

    public static Class<?> getRaw(String cls) throws ClassNotFoundException {
        return Class.forName(cls);
    }

    public static Class<?> getWithApi(String pre, String post) throws ClassNotFoundException {
        MCVersion mc = MCVersion.getCurrentCorrected();
        for (int i = 0; i <= 10; ++i) {
            String apiClass = i != 10 ? String.format("%s.v1_%s_R%s.%s", pre, mc.major, i, post) : pre + "." + post;
            try {
                return ClassGetter.getRaw(apiClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        throw new ClassNotFoundException("couldn't find any class matching " + pre + ".###." + post);
    }

    public static Class<?> getCompat(String pattern) throws ClassNotFoundException {
        MCVersion mc = MCVersion.getCurrentCorrected();
        for (int i = mc.minor; i >= 0; --i) {
            String apiClass = i != 0 ? pattern.replace("X_X", "1_" + mc.major + "_" + i) : pattern.replace("X_X", "1_" + mc.major);
            try {
                return ClassGetter.getRaw(apiClass);
            }
            catch (NoClassDefFoundError e) {
                if (!pattern.contains("mojang")) {
                    return ClassGetter.getCompat(pattern.replace("mc_X_X.", "mc_X_X.mojang."));
                }
                throw e;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        if (mc.major <= 8) {
            try {
                return ClassGetter.getRaw(pattern.replace("X_X", "1_8_8"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("couldn't find any class matching " + pattern);
    }
}

