/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.util.reflection;

import java.lang.reflect.Field;
import java.util.logging.Level;
import me.kcra.takenaka.accessor.mapping.ClassMapping;
import me.kcra.takenaka.accessor.mapping.FieldMapping;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.ViveMain;
import org.vivecraft.util.MCVersion;
import org.vivecraft.util.reflection.ClassGetter;

public class ReflectionField {
    public final Field field;

    private ReflectionField(Field field) {
        this.field = field;
    }

    private static ReflectionField getField(Class<?> cls, String fieldName) throws NoSuchFieldException {
        return new ReflectionField(cls.getDeclaredField(fieldName));
    }

    public static ReflectionField getField(FieldMapping ... mappings) {
        return ReflectionField.getField(true, mappings);
    }

    public static ReflectionField getField(boolean critical, FieldMapping ... mappings) {
        String namespace;
        Field f = null;
        String[] stringArray = new String[]{"spigot", "mojang"};
        int n = stringArray.length;
        for (int i = 0; i < n && (f = ReflectionField.getField(namespace = stringArray[i], mappings)) == null; ++i) {
        }
        if (f == null) {
            if (critical) {
                throw new RuntimeException("Unsupported mc version: " + MCVersion.getCurrent().version + ", no mapping found for: " + mappings[0].getParent().getName() + "." + mappings[0].getName());
            }
            return null;
        }
        f.setAccessible(true);
        return new ReflectionField(f);
    }

    public static ReflectionField getField(ClassMapping mapping, String fieldName) {
        try {
            ReflectionField f = ReflectionField.getField(ClassGetter.getClass(true, mapping), fieldName);
            f.field.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unsupported mc version: " + MCVersion.getCurrent().version + ", no mapping found for: " + mapping.getName() + "." + fieldName);
        }
    }

    @Nullable
    private static Field getField(String namespace, FieldMapping ... mappings) {
        MCVersion mc = MCVersion.getCurrentCorrected();
        Field f = null;
        for (FieldMapping mapping : mappings) {
            int minor = mc.minor;
            for (int major = mc.major; major > 7 && f == null; --major) {
                while (minor >= 0 && f == null) {
                    f = minor == 0 ? mapping.getField("1." + major, namespace) : mapping.getField("1." + major + "." + minor, namespace);
                    --minor;
                }
                minor = 10;
            }
            if (f == null && mc.major <= 8) {
                f = mapping.getField("1.8.8", namespace);
            }
            if (f == null) {
                f = mapping.getField();
            }
            if (f != null) break;
        }
        return f;
    }

    public static ReflectionField getWithApi(String pre, String post, String fieldName) {
        try {
            Class<?> c = ClassGetter.getWithApi(pre, post);
            return ReflectionField.getField(c, fieldName);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException("couldn't find any field matching " + pre + ".###." + post + "." + fieldName);
        }
    }

    public static ReflectionField getRaw(String cls, String fieldName, boolean required) {
        try {
            return ReflectionField.getField(ClassGetter.getRaw(cls), fieldName);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("couldn't find field " + cls + "." + fieldName, e);
        }
    }

    public Object get() {
        try {
            return this.field.get(null);
        }
        catch (IllegalAccessException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "couldn't get static field " + this.field.getName() + " from: " + this.field.getDeclaringClass().getName(), e);
            return null;
        }
    }

    public void set(Object value) {
        try {
            this.field.set(null, value);
        }
        catch (IllegalAccessException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "couldn't set static field " + this.field.getName() + " of: " + this.field.getDeclaringClass().getName(), e);
        }
    }

    public Object get(Object target) {
        try {
            return this.field.get(target);
        }
        catch (IllegalAccessException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "couldn't get field " + this.field.getName() + " from: " + target.getClass().getName(), e);
            return null;
        }
    }

    public void set(Object target, Object value) {
        try {
            this.field.set(target, value);
        }
        catch (IllegalAccessException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "couldn't set field " + this.field.getName() + " of: " + target.getClass().getName(), e);
        }
    }
}

