/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import me.kcra.takenaka.accessor.mapping.MethodMapping;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.ViveMain;
import org.vivecraft.util.MCVersion;
import org.vivecraft.util.reflection.ClassGetter;

public class ReflectionMethod {
    public final Method method;

    private ReflectionMethod(Method method) {
        this.method = method;
    }

    public static ReflectionMethod getMethod(Class<?> cls, String fieldName, Class<?> ... args) throws NoSuchMethodException {
        return new ReflectionMethod(cls.getDeclaredMethod(fieldName, args));
    }

    public static ReflectionMethod getMethod(MethodMapping ... mappings) {
        return ReflectionMethod.getMethod(true, mappings);
    }

    public static ReflectionMethod getMethod(boolean critical, MethodMapping ... mappings) {
        String namespace;
        Method m = null;
        String[] stringArray = new String[]{"spigot", "mojang"};
        int n = stringArray.length;
        for (int i = 0; i < n && (m = ReflectionMethod.getMethod(namespace = stringArray[i], mappings)) == null; ++i) {
        }
        if (m == null) {
            if (critical) {
                throw new RuntimeException("Unsupported mc version: " + MCVersion.getCurrent() + ", no mapping found for: " + mappings[0].getParent().getName() + "." + mappings[0].getName());
            }
            return null;
        }
        m.setAccessible(true);
        return new ReflectionMethod(m);
    }

    @Nullable
    private static Method getMethod(String namespace, MethodMapping ... mappings) {
        MCVersion mc = MCVersion.getCurrentCorrected();
        Method m = null;
        for (MethodMapping mapping : mappings) {
            int minor = mc.minor;
            for (int major = mc.major; major > 7 && m == null; --major) {
                while (minor >= 0 && m == null) {
                    m = minor == 0 ? mapping.getMethod("1." + major, namespace) : mapping.getMethod("1." + major + "." + minor, namespace);
                    --minor;
                }
                minor = 10;
            }
            if (m != null || mc.major > 8) continue;
            m = mapping.getMethod("1.8.8", namespace);
        }
        return m;
    }

    public static ReflectionMethod getWithApi(String pre, String post, String methodName, Class<?> ... args) {
        try {
            Class<?> c = ClassGetter.getWithApi(pre, post);
            return ReflectionMethod.getMethod(c, methodName, args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("couldn't find any method matching " + pre + ".###." + post + "." + methodName + " with args: " + Arrays.toString(args), e);
        }
    }

    public static ReflectionMethod getRaw(String cls, String methodName, Class<?> ... args) {
        try {
            return ReflectionMethod.getMethod(ClassGetter.getRaw(cls), methodName, args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("couldn't find method " + cls + "." + methodName + " with args: " + Arrays.toString(args), e);
        }
    }

    public Object invokes(Object ... args) {
        try {
            return this.method.invoke(null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "couldn't invoke static method " + this.method.getName() + " on: " + this.method.getDeclaringClass().getName(), e);
            return null;
        }
    }

    public Object invoke(Object target, Object ... args) {
        try {
            return this.method.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            ViveMain.LOGGER.log(Level.SEVERE, "couldn't invoke method " + this.method.getName() + " on: " + target.getClass().getName(), e);
            return null;
        }
    }
}

