/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="jurassicrevived")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue REQUIRE_POWER_SPEC = BUILDER.comment("If true, power systems are enabled. If false, disabled. Requires a restart to take effect").gameRestart().define("requirePower", false);
    private static final ModConfigSpec.BooleanValue NATURAL_DINOSAUR_SPAWNING_SPEC = BUILDER.comment("If true, dinosaurs spawn naturally in the world. If false, dinosaurs don't naturally spawn. Requires a restart to take effect, and will not affect existing dinosaurs in the world.").gameRestart().define("naturalDinoSpawning", false);
    private static final int MAX_ITEMS_PER_SEC = 1024;
    private static final int MAX_MB_PER_SEC = 100000;
    private static final int MAX_FE_PER_SEC = 0x200000;
    private static final ModConfigSpec.IntValue ITEMS_PER_SECOND = BUILDER.comment("Max items transferred per second by pipes").comment("Default: 64").defineInRange("itemsPerSecond", Math.min(64, 1024), 0, 1024);
    private static final ModConfigSpec.IntValue MB_PER_SECOND = BUILDER.comment("Max millibuckets transferred per second by pipes").comment("Default: 1,000").defineInRange("milliBucketsPerSecond", Math.min(1000, 100000), 0, 100000);
    private static final ModConfigSpec.IntValue FE_PER_SECOND = BUILDER.comment("Max FE transferred per second by pipes").comment("Default: 2,048").defineInRange("fePerSecond", Math.min(2048, 0x200000), 0, 0x200000);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean REQUIRE_POWER;
    public static boolean NATURAL_DINOSAUR_SPAWNING;
    public static int itemsPerSecond;
    public static int milliBucketsPerSecond;
    public static int fePerSecond;

    @SubscribeEvent
    static void onConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.bake();
        }
    }

    @SubscribeEvent
    static void onConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.bake();
        }
    }

    private static void bake() {
        REQUIRE_POWER = (Boolean)REQUIRE_POWER_SPEC.get();
        NATURAL_DINOSAUR_SPAWNING = (Boolean)NATURAL_DINOSAUR_SPAWNING_SPEC.get();
        itemsPerSecond = (Integer)ITEMS_PER_SECOND.get();
        milliBucketsPerSecond = (Integer)MB_PER_SECOND.get();
        fePerSecond = (Integer)FE_PER_SECOND.get();
    }

    public static void setNaturalDinosaurSpawning(boolean value) {
        NATURAL_DINOSAUR_SPAWNING_SPEC.set((Object)value);
        NATURAL_DINOSAUR_SPAWNING = value;
    }

    public static void setRequirePower(boolean value) {
        REQUIRE_POWER_SPEC.set((Object)value);
        REQUIRE_POWER = value;
    }

    public static void setItemsPerSecond(int value) {
        ITEMS_PER_SECOND.set((Object)Math.max(0, Math.min(value, 1024)));
        itemsPerSecond = (Integer)ITEMS_PER_SECOND.get();
    }

    public static void setMilliBucketsPerSecond(int value) {
        MB_PER_SECOND.set((Object)Math.max(0, Math.min(value, 100000)));
        milliBucketsPerSecond = (Integer)MB_PER_SECOND.get();
    }

    public static void setFePerSecond(int value) {
        FE_PER_SECOND.set((Object)Math.max(0, Math.min(value, 0x200000)));
        fePerSecond = (Integer)FE_PER_SECOND.get();
    }
}

