/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.cmr.jurassicrevived.entity.ModEntities;
import net.cmr.jurassicrevived.entity.SeatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BenchBlock
extends HorizontalDirectionalBlock {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)19.0, (double)19.0);

    public BenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> SHAPE;
            case Direction.EAST -> BenchBlock.rotateShape90Y(SHAPE);
            case Direction.SOUTH -> BenchBlock.rotateShape90Y(BenchBlock.rotateShape90Y(SHAPE));
            case Direction.WEST -> BenchBlock.rotateShape90Y(BenchBlock.rotateShape90Y(BenchBlock.rotateShape90Y(SHAPE)));
            default -> SHAPE;
        };
    }

    private static VoxelShape rotateShape90Y(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double rMinX = 1.0 - maxZ;
            double rMinZ = minX;
            double rMaxX = 1.0 - minZ;
            double rMaxZ = maxX;
            VoxelShape rotated = Block.box((double)(rMinX * 16.0), (double)(minY * 16.0), (double)(rMinZ * 16.0), (double)(rMaxX * 16.0), (double)(maxY * 16.0), (double)(rMaxZ * 16.0));
            buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)rotated);
        });
        return buffer[1].optimize();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        AABB check = new AABB(pos).inflate(0.2);
        Iterator iterator = level.getEntitiesOfClass(SeatEntity.class, check).iterator();
        if (iterator.hasNext()) {
            SeatEntity seat = (SeatEntity)((Object)iterator.next());
            if (seat.getPassengers().isEmpty()) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                Vec3 base = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 0.45, 0.0);
                double forward = -0.2;
                Vec3 offset = switch (facing) {
                    case Direction.NORTH -> new Vec3(0.0, 0.0, forward);
                    case Direction.SOUTH -> new Vec3(0.0, 0.0, -forward);
                    case Direction.WEST -> new Vec3(forward, 0.0, 0.0);
                    case Direction.EAST -> new Vec3(-forward, 0.0, 0.0);
                    default -> Vec3.ZERO;
                };
                Vec3 seatPos = base.add(offset);
                seat.moveTo(seatPos.x, seatPos.y, seatPos.z, facing.toYRot(), 0.0f);
                level.sendBlockUpdated(pos, state, state, 3);
                seat.scheduleMount(player.getUUID());
                return InteractionResult.CONSUME;
            }
            return InteractionResult.CONSUME;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec3 base = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 0.45, 0.0);
        double forward = -0.2;
        Vec3 offset = switch (facing) {
            case Direction.NORTH -> new Vec3(0.0, 0.0, forward);
            case Direction.SOUTH -> new Vec3(0.0, 0.0, -forward);
            case Direction.WEST -> new Vec3(forward, 0.0, 0.0);
            case Direction.EAST -> new Vec3(-forward, 0.0, 0.0);
            default -> Vec3.ZERO;
        };
        Vec3 seatPos = base.add(offset);
        SeatEntity seat = (SeatEntity)ModEntities.SEAT.get().create(level);
        if (seat == null) {
            return InteractionResult.PASS;
        }
        seat.moveTo(seatPos.x, seatPos.y, seatPos.z, facing.toYRot(), 0.0f);
        level.addFreshEntity((Entity)seat);
        seat.moveTo(seatPos.x, seatPos.y, seatPos.z, facing.toYRot(), 0.0f);
        level.sendBlockUpdated(pos, state, state, 3);
        seat.scheduleMount(player.getUUID());
        return InteractionResult.CONSUME;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            for (SeatEntity seat : level.getEntitiesOfClass(SeatEntity.class, new AABB(pos).inflate(0.5))) {
                seat.discard();
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

