/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.custom;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.cmr.jurassicrevived.block.entity.custom.CrateBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class CrateBlock
extends BaseEntityBlock {
    private final int slots;

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public CrateBlock(BlockBehaviour.Properties properties, int slots) {
        super(properties);
        this.slots = slots;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrateBlockEntity(pos, state, this.slots);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.defaultBlockState();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.getAbilities().instabuild) {
                level.removeBlockEntity(pos);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                return state;
            }
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof CrateBlockEntity) {
                CrateBlockEntity fbe = (CrateBlockEntity)be;
                ItemStack stack = new ItemStack((ItemLike)this.asItem());
                if (!fbe.isEmptyForDrop()) {
                    CompoundTag tag = fbe.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                    ResourceLocation beTypeKey = level.registryAccess().registryOrThrow(Registries.BLOCK_ENTITY_TYPE).getKey((Object)fbe.getType());
                    if (beTypeKey != null) {
                        tag.putString("id", beTypeKey.toString());
                    }
                    stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
                }
                CrateBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                level.removeBlockEntity(pos);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                return state;
            }
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.getBlock() != pNewState.getBlock()) {
            // empty if block
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)be;
            return crate.redstoneSignal();
        }
        return 0;
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        super.triggerEvent(state, level, pos, id, param);
        BlockEntity be = level.getBlockEntity(pos);
        return be != null && be.triggerEvent(id, param);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be;
        if (!level.isClientSide() && (be = level.getBlockEntity(pos)) instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)be;
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)crate, (Component)Component.empty()), pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

