/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.custom;

import com.mojang.serialization.MapCodec;
import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.cmr.jurassicrevived.block.entity.custom.EmbryoCalcificationMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EmbryoCalcificationMachineBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final MapCodec<EmbryoCalcificationMachineBlock> CODEC = EmbryoCalcificationMachineBlock.simpleCodec(EmbryoCalcificationMachineBlock::new);
    private static final VoxelShape SHAPE_NORTH = Shapes.box((double)0.0625, (double)0.0, (double)0.25, (double)0.9375, (double)1.0625, (double)0.875);
    private static final VoxelShape SHAPE_SOUTH = EmbryoCalcificationMachineBlock.rotateShapeY(SHAPE_NORTH, 180);
    private static final VoxelShape SHAPE_WEST = EmbryoCalcificationMachineBlock.rotateShapeY(SHAPE_NORTH, -90);
    private static final VoxelShape SHAPE_EAST = EmbryoCalcificationMachineBlock.rotateShapeY(SHAPE_NORTH, 90);

    public EmbryoCalcificationMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static VoxelShape rotateShapeY(VoxelShape shape, int degrees) {
        double rad = Math.toRadians((degrees % 360 + 360) % 360);
        int turns = (int)Math.round(rad / 1.5707963267948966);
        turns = (turns % 4 + 4) % 4;
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        for (int i = 0; i < turns; ++i) {
            buffer[1] = Shapes.empty();
            shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double nMinX = 1.0 - maxZ;
                double nMinZ = minX;
                double nMaxX = 1.0 - minZ;
                double nMaxZ = maxX;
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)nMinX, (double)minY, (double)nMinZ, (double)nMaxX, (double)maxY, (double)nMaxZ));
            });
            shape = buffer[1];
        }
        return shape;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite().getOpposite())).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return switch (dir) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EmbryoCalcificationMachineBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.getAbilities().instabuild) {
                level.removeBlockEntity(pos);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                return state;
            }
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof EmbryoCalcificationMachineBlockEntity) {
                EmbryoCalcificationMachineBlockEntity fbe = (EmbryoCalcificationMachineBlockEntity)be;
                ItemStack stack = new ItemStack((ItemLike)this.asItem());
                if (!fbe.isEmptyForDrop()) {
                    CompoundTag tag = fbe.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                    ResourceLocation beTypeKey = level.registryAccess().registryOrThrow(Registries.BLOCK_ENTITY_TYPE).getKey((Object)fbe.getType());
                    if (beTypeKey != null) {
                        tag.putString("id", beTypeKey.toString());
                    }
                    stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
                }
                EmbryoCalcificationMachineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                level.removeBlockEntity(pos);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                return state;
            }
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.getBlock() != pNewState.getBlock()) {
            // empty if block
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide()) {
            BlockEntity entity = pLevel.getBlockEntity(pPos);
            if (entity instanceof EmbryoCalcificationMachineBlockEntity) {
                EmbryoCalcificationMachineBlockEntity embryoCalcificationMachineBlockEntity = (EmbryoCalcificationMachineBlockEntity)entity;
                ((ServerPlayer)pPlayer).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)embryoCalcificationMachineBlockEntity, (Component)Component.translatable((String)"block.jurassicrevived.embryo_calcification_machine")), pPos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType != ModBlockEntities.EMBRYO_CALCIFICATION_MACHINE_BE.get()) {
            return null;
        }
        if (level.isClientSide) {
            return (lvl, pos, st, be) -> {
                if (be instanceof EmbryoCalcificationMachineBlockEntity) {
                    EmbryoCalcificationMachineBlockEntity extractor = (EmbryoCalcificationMachineBlockEntity)be;
                    EmbryoCalcificationMachineBlockEntity.clientTick(lvl, pos, st, extractor);
                }
            };
        }
        return EmbryoCalcificationMachineBlock.createTickerHelper(blockEntityType, ModBlockEntities.EMBRYO_CALCIFICATION_MACHINE_BE.get(), (level1, blockPos, blockState, embryoCalcificationMachineBlockEntity) -> embryoCalcificationMachineBlockEntity.tick(level1, blockPos, blockState));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double xPos = (double)pos.getX() + 0.5;
        double yPos = pos.getY();
        double zPos = (double)pos.getZ() + 0.5;
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        Direction.Axis axis = direction.getAxis();
        double defaultOffset = random.nextDouble() * 0.6 - 0.3;
        double xOffsets = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : defaultOffset;
        double yOffset = random.nextDouble() * 6.0 / 8.0;
        double zOffset = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : defaultOffset;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, xPos + xOffsets, yPos + yOffset, zPos + zOffset, 0.0, 0.0, 0.0);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EmbryoCalcificationMachineBlockEntity) {
            EmbryoCalcificationMachineBlockEntity embryoCalcificationMachineBlockEntity = (EmbryoCalcificationMachineBlockEntity)blockEntity;
            if (!embryoCalcificationMachineBlockEntity.itemHandler.getStackInSlot(1).isEmpty()) {
                level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, embryoCalcificationMachineBlockEntity.itemHandler.getStackInSlot(1)), xPos + xOffsets, yPos + yOffset, zPos + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }
}

