/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.custom;

import net.cmr.jurassicrevived.block.custom.FenceWireBlock;
import net.cmr.jurassicrevived.util.FenceUpdateGuard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FencePoleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty NE = BooleanProperty.create((String)"ne");
    public static final BooleanProperty SE = BooleanProperty.create((String)"se");
    public static final BooleanProperty SW = BooleanProperty.create((String)"sw");
    public static final BooleanProperty NW = BooleanProperty.create((String)"nw");
    public static final IntegerProperty TIER = IntegerProperty.create((String)"tier", (int)0, (int)2);
    private final Tier tierConfig;
    private static final VoxelShape POST = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    private static final VoxelShape ARM_NORTH = Block.box((double)7.5, (double)2.5, (double)0.0, (double)8.5, (double)13.5, (double)8.0);
    private static final VoxelShape ARM_SOUTH = Block.box((double)7.5, (double)2.5, (double)8.0, (double)8.5, (double)13.5, (double)16.0);
    private static final VoxelShape ARM_WEST = Block.box((double)0.0, (double)2.5, (double)7.5, (double)8.0, (double)13.5, (double)8.5);
    private static final VoxelShape ARM_EAST = Block.box((double)8.0, (double)2.5, (double)7.5, (double)16.0, (double)13.5, (double)8.5);
    private static final VoxelShape DIAG_NE = FencePoleBlock.buildDiagonal(true, false);
    private static final VoxelShape DIAG_SE = FencePoleBlock.buildDiagonal(true, true);
    private static final VoxelShape DIAG_SW = FencePoleBlock.buildDiagonal(false, true);
    private static final VoxelShape DIAG_NW = FencePoleBlock.buildDiagonal(false, false);
    private static final VoxelShape[] SHAPES = new VoxelShape[256];

    public FencePoleBlock(BlockBehaviour.Properties properties, Tier tier) {
        super(properties);
        this.tierConfig = tier;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NE, (Comparable)Boolean.valueOf(false))).setValue((Property)SE, (Comparable)Boolean.valueOf(false))).setValue((Property)SW, (Comparable)Boolean.valueOf(false))).setValue((Property)NW, (Comparable)Boolean.valueOf(false))).setValue((Property)TIER, (Comparable)Integer.valueOf(tier.id))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, NORTH, EAST, SOUTH, WEST, NE, SE, SW, NW, TIER});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        FluidState fluid = level.getFluidState(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)level, pos, Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)level, pos, Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)level, pos, Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)level, pos, Direction.WEST)))).setValue((Property)NE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.EAST)))).setValue((Property)SE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.EAST)))).setValue((Property)SW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.WEST)))).setValue((Property)NW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.WEST)))).setValue((Property)TIER, (Comparable)Integer.valueOf(this.tierConfig.id))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (dir.getAxis().isHorizontal()) {
            boolean connect = this.connectsTo(level, pos, dir);
            state = (BlockState)state.setValue((Property)FencePoleBlock.propertyFor(dir), (Comparable)Boolean.valueOf(connect));
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockState updated = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.EAST)))).setValue((Property)SE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.EAST)))).setValue((Property)SW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.WEST)))).setValue((Property)NW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.WEST)));
        if (updated != state) {
            level.setBlock(pos, updated, 2);
        }
        if (FencePoleBlock.beginGuard()) {
            try {
                this.updateDiagonalsAround(level, pos);
            }
            finally {
                FencePoleBlock.endGuard();
            }
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    private static boolean beginGuard() {
        return FenceUpdateGuard.begin();
    }

    private static void endGuard() {
        FenceUpdateGuard.end();
    }

    private void updateDiagonalsAround(Level level, BlockPos pos) {
        BlockPos[] diags;
        for (BlockPos p : diags = new BlockPos[]{pos.north().east(), pos.south().east(), pos.south().west(), pos.north().west()}) {
            BlockState updated;
            boolean nw;
            boolean sw;
            boolean se;
            boolean ne;
            BlockState bs = level.getBlockState(p);
            Block b = bs.getBlock();
            if (b instanceof FencePoleBlock) {
                ne = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.EAST);
                se = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.EAST);
                sw = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.WEST);
                nw = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.WEST);
                updated = (BlockState)((BlockState)((BlockState)((BlockState)bs.setValue((Property)NE, (Comparable)Boolean.valueOf(ne))).setValue((Property)SE, (Comparable)Boolean.valueOf(se))).setValue((Property)SW, (Comparable)Boolean.valueOf(sw))).setValue((Property)NW, (Comparable)Boolean.valueOf(nw));
                if (updated == bs) continue;
                level.setBlock(p, updated, 2);
                continue;
            }
            if (!(b instanceof FenceWireBlock)) continue;
            ne = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.EAST);
            se = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.EAST);
            sw = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.WEST);
            nw = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.WEST);
            updated = (BlockState)((BlockState)((BlockState)((BlockState)bs.setValue((Property)FenceWireBlock.NE, (Comparable)Boolean.valueOf(ne))).setValue((Property)FenceWireBlock.SE, (Comparable)Boolean.valueOf(se))).setValue((Property)FenceWireBlock.SW, (Comparable)Boolean.valueOf(sw))).setValue((Property)FenceWireBlock.NW, (Comparable)Boolean.valueOf(nw));
            if (updated == bs) continue;
            level.setBlock(p, updated, 2);
        }
    }

    private boolean connectsTo(LevelAccessor level, BlockPos pos, Direction dir) {
        BlockPos neighborPos = pos.relative(dir);
        BlockState neighbor = level.getBlockState(neighborPos);
        Block nb = neighbor.getBlock();
        if (nb instanceof FenceWireBlock || nb instanceof FencePoleBlock) {
            return true;
        }
        return neighbor.isFaceSturdy((BlockGetter)level, neighborPos, dir.getOpposite());
    }

    private static BooleanProperty propertyFor(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> throw new IllegalArgumentException("Only horizontal");
        };
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    private static VoxelShape buildDiagonal(boolean east, boolean south) {
        VoxelShape shape = Shapes.empty();
        double y1 = 2.5;
        double y2 = 13.5;
        for (int i = 0; i < 8; ++i) {
            double off = i;
            double x1 = east ? 16.0 - (off + 1.0) : 0.0 + off;
            double x2 = x1 + 1.0;
            double z1 = south ? 16.0 - (off + 1.0) : 0.0 + off;
            double z2 = z1 + 1.0;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
        }
        return shape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int mask = 0;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            mask |= 1;
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            mask |= 2;
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            mask |= 4;
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            mask |= 8;
        }
        if (((Boolean)state.getValue((Property)NE)).booleanValue()) {
            mask |= 0x10;
        }
        if (((Boolean)state.getValue((Property)SE)).booleanValue()) {
            mask |= 0x20;
        }
        if (((Boolean)state.getValue((Property)SW)).booleanValue()) {
            mask |= 0x40;
        }
        if (((Boolean)state.getValue((Property)NW)).booleanValue()) {
            mask |= 0x80;
        }
        return SHAPES[mask];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getShape(state, level, pos, ctx);
    }

    static {
        for (int mask = 0; mask < SHAPES.length; ++mask) {
            VoxelShape s = POST;
            if ((mask & 1) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)ARM_NORTH);
            }
            if ((mask & 2) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)ARM_EAST);
            }
            if ((mask & 4) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)ARM_SOUTH);
            }
            if ((mask & 8) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)ARM_WEST);
            }
            if ((mask & 0x10) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)DIAG_NE);
            }
            if ((mask & 0x20) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)DIAG_SE);
            }
            if ((mask & 0x40) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)DIAG_SW);
            }
            if ((mask & 0x80) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)DIAG_NW);
            }
            FencePoleBlock.SHAPES[mask] = s;
        }
    }

    public static enum Tier {
        LOW(0),
        MEDIUM(1),
        HIGH(2);

        public final int id;

        private Tier(int id) {
            this.id = id;
        }
    }
}

