/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.custom;

import net.cmr.jurassicrevived.block.custom.FencePoleBlock;
import net.cmr.jurassicrevived.util.FenceUpdateGuard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FenceWireBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty NE = BooleanProperty.create((String)"ne");
    public static final BooleanProperty SE = BooleanProperty.create((String)"se");
    public static final BooleanProperty SW = BooleanProperty.create((String)"sw");
    public static final BooleanProperty NW = BooleanProperty.create((String)"nw");
    public static final IntegerProperty TIER = IntegerProperty.create((String)"tier", (int)0, (int)2);
    private final Tier tierConfig;
    private static final VoxelShape CENTER = Block.box((double)7.5, (double)2.5, (double)7.5, (double)8.5, (double)13.5, (double)8.5);
    private static final VoxelShape ARM_NORTH = Block.box((double)7.5, (double)2.5, (double)0.0, (double)8.5, (double)13.5, (double)8.0);
    private static final VoxelShape ARM_SOUTH = Block.box((double)7.5, (double)2.5, (double)8.0, (double)8.5, (double)13.5, (double)16.0);
    private static final VoxelShape ARM_WEST = Block.box((double)0.0, (double)2.5, (double)7.5, (double)8.0, (double)13.5, (double)8.5);
    private static final VoxelShape ARM_EAST = Block.box((double)8.0, (double)2.5, (double)7.5, (double)16.0, (double)13.5, (double)8.5);
    private static final VoxelShape DIAG_NE = FenceWireBlock.buildDiagonal(true, false);
    private static final VoxelShape DIAG_SE = FenceWireBlock.buildDiagonal(true, true);
    private static final VoxelShape DIAG_SW = FenceWireBlock.buildDiagonal(false, true);
    private static final VoxelShape DIAG_NW = FenceWireBlock.buildDiagonal(false, false);
    private static final VoxelShape[] SHAPES = new VoxelShape[256];

    private static boolean beginGuard() {
        return FenceUpdateGuard.begin();
    }

    private static void endGuard() {
        FenceUpdateGuard.end();
    }

    public FenceWireBlock(BlockBehaviour.Properties properties, Tier tier) {
        super(properties);
        this.tierConfig = tier;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)NE, (Comparable)Boolean.valueOf(false))).setValue((Property)SE, (Comparable)Boolean.valueOf(false))).setValue((Property)SW, (Comparable)Boolean.valueOf(false))).setValue((Property)NW, (Comparable)Boolean.valueOf(false))).setValue((Property)TIER, (Comparable)Integer.valueOf(tier.id))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, POWERED, NE, SE, SW, NW, TIER, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        boolean powered = level.hasNeighborSignal(pos);
        boolean waterlogged = level.getFluidState(pos).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsCardinalTo((LevelAccessor)level, pos, Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsCardinalTo((LevelAccessor)level, pos, Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsCardinalTo((LevelAccessor)level, pos, Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsCardinalTo((LevelAccessor)level, pos, Direction.WEST)))).setValue((Property)NE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.EAST)))).setValue((Property)SE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.EAST)))).setValue((Property)SW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.WEST)))).setValue((Property)NW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.WEST)))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)TIER, (Comparable)Integer.valueOf(this.tierConfig.id))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (dir.getAxis().isHorizontal()) {
            boolean connect = this.connectsCardinalTo(level, pos, dir);
            state = (BlockState)state.setValue((Property)FenceWireBlock.propertyFor(dir), (Comparable)Boolean.valueOf(connect));
        }
        state = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally(level, pos, Direction.NORTH, Direction.EAST)))).setValue((Property)SE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally(level, pos, Direction.SOUTH, Direction.EAST)))).setValue((Property)SW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally(level, pos, Direction.SOUTH, Direction.WEST)))).setValue((Property)NW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally(level, pos, Direction.NORTH, Direction.WEST)));
        return state;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean poweredNow = level.hasNeighborSignal(pos);
        if (poweredNow != (Boolean)state.getValue((Property)POWERED)) {
            if (FenceWireBlock.beginGuard()) {
                try {
                    level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(poweredNow)), 3);
                }
                finally {
                    FenceWireBlock.endGuard();
                }
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(poweredNow)), 3);
            }
        }
        if (FenceWireBlock.beginGuard()) {
            try {
                BlockState updated = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.EAST)))).setValue((Property)SE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.EAST)))).setValue((Property)SW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.WEST)))).setValue((Property)NW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.WEST)));
                if (updated != state) {
                    level.setBlock(pos, updated, 2);
                }
                this.updateDiagonalsAround(level, pos);
            }
            finally {
                FenceWireBlock.endGuard();
            }
        }
    }

    private void recomputeSelfDiagonals(Level level, BlockPos pos, BlockState state) {
        BlockState updated = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.EAST)))).setValue((Property)SE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.EAST)))).setValue((Property)SW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.SOUTH, Direction.WEST)))).setValue((Property)NW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, pos, Direction.NORTH, Direction.WEST)));
        if (updated != state) {
            level.setBlock(pos, updated, 2);
        }
    }

    private void updateDiagonalsAround(Level level, BlockPos pos) {
        BlockPos[] diags;
        BlockPos nePos = pos.north().east();
        BlockPos sePos = pos.south().east();
        BlockPos swPos = pos.south().west();
        BlockPos nwPos = pos.north().west();
        for (BlockPos p : diags = new BlockPos[]{nePos, sePos, swPos, nwPos}) {
            BlockState updated;
            BlockState bs = level.getBlockState(p);
            Block b = bs.getBlock();
            if (b instanceof FencePoleBlock) {
                Direction backB;
                Direction backA;
                BooleanProperty backFlag;
                if (p.equals((Object)nePos)) {
                    backFlag = FencePoleBlock.SW;
                    backA = Direction.SOUTH;
                    backB = Direction.WEST;
                } else if (p.equals((Object)sePos)) {
                    backFlag = FencePoleBlock.NW;
                    backA = Direction.NORTH;
                    backB = Direction.WEST;
                } else if (p.equals((Object)swPos)) {
                    backFlag = FencePoleBlock.NE;
                    backA = Direction.NORTH;
                    backB = Direction.EAST;
                } else {
                    backFlag = FencePoleBlock.SE;
                    backA = Direction.SOUTH;
                    backB = Direction.EAST;
                }
                boolean allow = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, backA, backB);
                updated = (BlockState)bs.setValue((Property)backFlag, (Comparable)Boolean.valueOf(allow));
                if (updated == bs) continue;
                level.setBlock(p, updated, 2);
                continue;
            }
            if (!(b instanceof FenceWireBlock)) continue;
            boolean ne = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.EAST);
            boolean se = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.EAST);
            boolean sw = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.WEST);
            boolean nw = FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.WEST);
            updated = (BlockState)((BlockState)((BlockState)((BlockState)bs.setValue((Property)NE, (Comparable)Boolean.valueOf(ne))).setValue((Property)SE, (Comparable)Boolean.valueOf(se))).setValue((Property)SW, (Comparable)Boolean.valueOf(sw))).setValue((Property)NW, (Comparable)Boolean.valueOf(nw));
            if (updated == bs) continue;
            level.setBlock(p, updated, 2);
        }
    }

    public static boolean canConnectDiagonally(LevelAccessor level, BlockPos pos, Direction a, Direction b) {
        boolean stepBBlocks;
        boolean diagIsSolidCorner;
        BlockState srcState = level.getBlockState(pos);
        Block srcBlock = srcState.getBlock();
        BlockPos diag = pos.relative(a).relative(b);
        BlockState diagState = level.getBlockState(diag);
        Block diagBlock = diagState.getBlock();
        boolean srcIsPole = srcBlock instanceof FencePoleBlock;
        boolean diagIsWire = diagBlock instanceof FenceWireBlock;
        boolean diagIsPole = diagBlock instanceof FencePoleBlock;
        boolean bl = diagIsSolidCorner = diagState.isFaceSturdy((BlockGetter)level, diag, a.getOpposite()) || diagState.isFaceSturdy((BlockGetter)level, diag, b.getOpposite());
        if (!(diagIsWire || diagIsPole || diagIsSolidCorner)) {
            return false;
        }
        if (srcIsPole || diagIsPole) {
            return true;
        }
        BlockPos stepA = pos.relative(a);
        BlockPos stepB = pos.relative(b);
        BlockState stateA = level.getBlockState(stepA);
        BlockState stateB = level.getBlockState(stepB);
        boolean stepABlocks = stateA.getBlock() instanceof FenceWireBlock || stateA.getBlock() instanceof FencePoleBlock || stateA.isFaceSturdy((BlockGetter)level, stepA, a.getOpposite());
        boolean bl2 = stepBBlocks = stateB.getBlock() instanceof FenceWireBlock || stateB.getBlock() instanceof FencePoleBlock || stateB.isFaceSturdy((BlockGetter)level, stepB, b.getOpposite());
        return !stepABlocks && !stepBBlocks;
    }

    private static boolean canConnectDiagonallyToFence(LevelAccessor level, BlockPos pos, Direction a, Direction b) {
        BlockPos diag = pos.relative(a).relative(b);
        BlockState diagState = level.getBlockState(diag);
        Block db = diagState.getBlock();
        if (!(db instanceof FenceWireBlock) && !(db instanceof FencePoleBlock)) {
            return false;
        }
        return FenceWireBlock.canConnectDiagonally(level, pos, a, b);
    }

    private boolean connectsTo(BlockState neighbor) {
        Block b = neighbor.getBlock();
        return b instanceof FenceWireBlock || b instanceof FencePoleBlock;
    }

    private static BooleanProperty propertyFor(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> throw new IllegalArgumentException("Only horizontal");
        };
    }

    private boolean connectsCardinalTo(LevelAccessor level, BlockPos pos, Direction dir) {
        BlockPos neighborPos = pos.relative(dir);
        BlockState neighbor = level.getBlockState(neighborPos);
        Block nb = neighbor.getBlock();
        if (nb instanceof FencePoleBlock) {
            return true;
        }
        if (nb instanceof FenceWireBlock) {
            Direction right = dir.getClockWise();
            Direction left = dir.getCounterClockWise();
            boolean thisDiagRight = FenceWireBlock.canConnectDiagonallyToFence(level, pos, dir, right);
            boolean thisDiagLeft = FenceWireBlock.canConnectDiagonallyToFence(level, pos, dir, left);
            Direction back = dir.getOpposite();
            boolean neighDiagRight = FenceWireBlock.canConnectDiagonallyToFence(level, neighborPos, back, back.getClockWise());
            boolean neighDiagLeft = FenceWireBlock.canConnectDiagonallyToFence(level, neighborPos, back, back.getCounterClockWise());
            return !thisDiagRight && !thisDiagLeft && !neighDiagRight && !neighDiagLeft;
        }
        return neighbor.isFaceSturdy((BlockGetter)level, neighborPos, dir.getOpposite());
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    private static VoxelShape buildDiagonal(boolean east, boolean south) {
        VoxelShape shape = Shapes.empty();
        double y1 = 2.5;
        double y2 = 13.5;
        for (int i = 0; i < 8; ++i) {
            double off = i;
            double x1 = east ? 16.0 - (off + 1.0) : 0.0 + off;
            double x2 = x1 + 1.0;
            double z1 = south ? 16.0 - (off + 1.0) : 0.0 + off;
            double z2 = z1 + 1.0;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
        }
        return shape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int mask = 0;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            mask |= 1;
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            mask |= 2;
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            mask |= 4;
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            mask |= 8;
        }
        if (((Boolean)state.getValue((Property)NE)).booleanValue()) {
            mask |= 0x10;
        }
        if (((Boolean)state.getValue((Property)SE)).booleanValue()) {
            mask |= 0x20;
        }
        if (((Boolean)state.getValue((Property)SW)).booleanValue()) {
            mask |= 0x40;
        }
        if (((Boolean)state.getValue((Property)NW)).booleanValue()) {
            mask |= 0x80;
        }
        return SHAPES[mask];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getShape(state, level, pos, ctx);
    }

    static {
        for (int mask = 0; mask < SHAPES.length; ++mask) {
            VoxelShape s = CENTER;
            if ((mask & 1) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)ARM_NORTH);
            }
            if ((mask & 2) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)ARM_EAST);
            }
            if ((mask & 4) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)ARM_SOUTH);
            }
            if ((mask & 8) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)ARM_WEST);
            }
            if ((mask & 0x10) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)DIAG_NE);
            }
            if ((mask & 0x20) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)DIAG_SE);
            }
            if ((mask & 0x40) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)DIAG_SW);
            }
            if ((mask & 0x80) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape)DIAG_NW);
            }
            FenceWireBlock.SHAPES[mask] = s;
        }
    }

    public static enum Tier {
        LOW(0),
        MEDIUM(1),
        HIGH(2);

        public final int id;

        private Tier(int id) {
            this.id = id;
        }
    }
}

